/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiejb;

import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.osgijavaeebase.BundleClassLoader;
import org.glassfish.osgijavaeebase.OSGiArchiveHandler;
import org.glassfish.osgijavaeebase.OSGiDeploymentContext;
import org.osgi.framework.Bundle;

public class OSGiEJBDeploymentContext
extends OSGiDeploymentContext {
    public OSGiEJBDeploymentContext(ActionReport actionReport, Logger logger, ReadableArchive source, OpsParams params, ServerEnvironment env, Bundle bundle) throws Exception {
        super(actionReport, logger, source, params, env, bundle);
        this.setArchiveHandler((ArchiveHandler)new OSGiArchiveHandler(){

            public String getArchiveType() {
                return ModuleType.EJB.toString();
            }
        });
    }

    protected void setupClassLoader() throws Exception {
        BundleClassLoader delegate1 = new BundleClassLoader(this.bundle);
        ClassLoader delegate2 = ((ClassLoaderHierarchy)Globals.get(ClassLoaderHierarchy.class)).getAPIClassLoader();
        DelegatingInstrumentableClassLoader cl = new DelegatingInstrumentableClassLoader(delegate1, delegate2);
        this.shareableTempClassLoader = cl;
        this.finalClassLoader = cl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingInstrumentableClassLoader
    extends ClassLoader
    implements InstrumentableClassLoader {
        private BundleClassLoader delegate1;
        private ClassLoader delegate2;

        private DelegatingInstrumentableClassLoader(BundleClassLoader delegate1, ClassLoader delegate2) {
            this.delegate1 = delegate1;
            this.delegate2 = delegate2;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    return this.delegate1.loadClass(name, resolve);
                }
                catch (ClassNotFoundException cnfe) {
                    return this.delegate2.loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        @Override
        public URL getResource(String name) {
            URL url = this.delegate1.getResource(name);
            if (url == null) {
                url = this.delegate2.getResource(name);
            }
            return url;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
            enumerators.add(this.delegate1.getResources(name));
            enumerators.add(this.delegate2.getResources(name));
            return new CompositeEnumeration(enumerators);
        }

        public ClassLoader copy() {
            return this;
        }

        public void addTransformer(ClassFileTransformer transformer) {
            System.out.println("addTransformer called " + transformer);
        }
    }
}

