/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.util.Map;
import java.util.Set;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.IncludeSubclass;
import org.glassfish.gmbal.InheritedAttribute;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.ManagedOperation;
import org.glassfish.gmbal.NameValue;
import org.glassfish.pfl.tf.timer.impl.TimerFactoryImpl;
import org.glassfish.pfl.tf.timer.spi.Controllable;
import org.glassfish.pfl.tf.timer.spi.LogEventHandler;
import org.glassfish.pfl.tf.timer.spi.Named;
import org.glassfish.pfl.tf.timer.spi.Statistics;
import org.glassfish.pfl.tf.timer.spi.StatsEventHandler;
import org.glassfish.pfl.tf.timer.spi.Timer;
import org.glassfish.pfl.tf.timer.spi.TimerEventController;
import org.glassfish.pfl.tf.timer.spi.TimerEventControllerBase;
import org.glassfish.pfl.tf.timer.spi.TimerEventHandler;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;
import org.glassfish.pfl.tf.timer.spi.TimerGroup;

public class TimerAnnotationHelper {
    public static void registerTimerClasses(ManagedObjectManager mom) {
        for (Class<?> cls : TimerAnnotationHelper.class.getDeclaredClasses()) {
            mom.addInheritedAnnotations(cls);
        }
    }

    @ManagedObject
    @IncludeSubclass(value={Timer.class, TimerGroup.class, TimerFactory.class})
    public static interface ManagedControllable
    extends Controllable,
    ManagedNamed {
        @ManagedAttribute
        @Description(value="The purpose of the Timer or TimerGroup")
        public String description();

        @ManagedAttribute
        @Description(value="An internal identifier for the Timer or TimerGroup")
        public int id();

        @ManagedAttribute
        @Description(value="Set of Timers or TimerGroups contained in a TimerGroup")
        public Set<? extends Controllable> contents();

        @ManagedOperation
        @Description(value="Enable this Timer, or all Timers and TimerGroups contained in this TimerGroup")
        public void enable();

        @ManagedOperation
        @Description(value="Disable this Timer, or all Timers and TimerGroups contained in this TimerGroup")
        public void disable();

        @ManagedOperation
        @Description(value="True if this Timer or TimerGroup is enabled")
        public boolean isEnabled();
    }

    @ManagedObject
    @Description(value="TimerEventHandler that records all TimerEvents in a log")
    @InheritedAttribute(methodName="iterator", description="TimerEvents contained in this log in order of occurrence")
    public static interface ManagedLogEventHandler
    extends LogEventHandler,
    ManagedTimerEventHandler {
        @ManagedOperation
        @Description(value="Discard all recorded timer events")
        public void clear();
    }

    public static interface ManagedNamed
    extends Named {
        @ManagedAttribute
        @Description(value="TimerFactory that created this Timer or TimerGroup")
        public TimerFactory factory();

        @ManagedAttribute
        @NameValue
        @Description(value="Name of this Timer or TimerGroup")
        public String name();
    }

    @ManagedData
    @Description(value="Statistics recorded for a series of time intervals")
    public class ManagedStatistics
    extends Statistics {
        public ManagedStatistics(long count, double min, double max, double average, double standardDeviation) {
            super(count, min, max, average, standardDeviation);
        }

        @ManagedAttribute
        @Description(value="Total number of intervals recorded")
        public long count() {
            return super.count();
        }

        @ManagedAttribute
        @Description(value="Minimum interval duration recorded")
        public double min() {
            return super.min();
        }

        @ManagedAttribute
        @Description(value="Maximum interval duration recorded")
        public double max() {
            return super.max();
        }

        @ManagedAttribute
        @Description(value="Average interval duration recorded")
        public double average() {
            return super.average();
        }

        @ManagedAttribute
        @Description(value="Standard deviation of all durations recorded")
        public double standardDeviation() {
            return super.standardDeviation();
        }
    }

    @ManagedObject
    @Description(value="TimerEventHandler that accumulates statistics on events")
    public static interface ManagedStatsEventHandler
    extends StatsEventHandler,
    ManagedTimerEventHandler {
        @ManagedAttribute
        @Description(value="A table giving statistics for each activated Timer that had at least one TimerEvent")
        public Map<Timer, Statistics> stats();

        @ManagedOperation
        @Description(value="Discard all statistics on all Timers")
        public void clear();
    }

    @ManagedObject
    @Description(value="A timer represents a particular action that has a duration from ENTER to EXIT")
    public static interface ManagedTimer
    extends Timer,
    ManagedControllable {
        @ManagedAttribute
        @Description(value="True if this Timer is enabled, and can generate TimerEvents")
        public boolean isActivated();
    }

    @ManagedObject
    @Description(value="Controls entering and exiting Timers")
    public class ManagedTimerEventController
    extends TimerEventController
    implements ManagedNamed {
        public ManagedTimerEventController(TimerFactory factory, String name) {
            super(factory, name);
        }

        @ManagedOperation
        @Description(value="Enter a particular Timer")
        public void enter(Timer timer) {
            super.enter(timer);
        }

        @ManagedOperation
        @Description(value="Exit a particular Timer")
        public void exit(Timer timer) {
            super.exit(timer);
        }
    }

    public static interface ManagedTimerEventHandler
    extends TimerEventHandler,
    ManagedNamed {
    }

    @ManagedObject
    @Description(value="The Factory used to create and managed all objects in the Timer framework")
    public static interface ManagedTimerFactory
    extends TimerFactory,
    ManagedTimerGroup {
        @ManagedAttribute
        @Description(value="The total number of Controllabled IDs in use")
        public int numberOfIds();

        @ManagedOperation
        @Description(value="Look up a Timer or TimerGroup by its ID")
        public Controllable getControllable(int var1);

        @ManagedOperation
        @Description(value="Create a new LogEventHandler")
        public LogEventHandler makeLogEventHandler(String var1);

        @ManagedOperation
        @Description(value="Create a new TracingEventHandler")
        public TimerEventHandler makeTracingEventHandler(String var1);

        @ManagedOperation
        @Description(value="Create a new StatsEventHandler")
        public StatsEventHandler makeStatsEventHandler(String var1);

        @ManagedOperation
        @Description(value="Create a new Multi-Threaded StatsEventHandler")
        public StatsEventHandler makeMultiThreadedStatsEventHandler(String var1);

        @ManagedOperation
        @Description(value="Remove the TimerEventHandler from this factory")
        public void removeTimerEventHandler(TimerEventHandler var1);

        @ManagedOperation
        @Description(value="Create a new Timer")
        public Timer makeTimer(String var1, String var2);

        @ManagedAttribute
        @Description(value="All timers contained in this factory")
        public Map<String, ? extends Timer> timers();

        @ManagedOperation
        @Description(value="Create a new TimerGroup")
        public TimerGroup makeTimerGroup(String var1, String var2);

        @ManagedAttribute
        @Description(value="All timers contained in this factory")
        public Map<String, ? extends TimerGroup> timerGroups();

        @ManagedOperation
        @Description(value="Create a new TimerEventController")
        public TimerEventController makeController(String var1);

        @ManagedOperation
        @Description(value="Remote the TimerEventController from this factory")
        public void removeController(TimerEventControllerBase var1);

        @ManagedAttribute
        @Description(value="All explicitly enabled Timers and TimerGroups")
        public Set<? extends Controllable> enabledSet();

        @ManagedAttribute
        @Description(value="All activated Timers")
        public Set<Timer> activeSet();
    }

    @ManagedObject
    @Description(value="A group of Timers or other TimerGroups, which may be enabled or disabled together")
    public static interface ManagedTimerGroup
    extends TimerGroup,
    ManagedControllable {
        @ManagedOperation
        @Description(value="Add a new Timer or TimerGroup to this TimerGroup")
        public boolean add(Controllable var1);

        @ManagedOperation
        @Description(value="Remove a new Timer or TimerGroup from this TimerGroup")
        public boolean remove(Controllable var1);
    }

    @ManagedObject
    @Description(value="A simple TimerEventHandler that just displays TimerEvents as they occur")
    public class TracingEventHandler
    extends TimerFactoryImpl.TracingEventHandler
    implements ManagedTimerEventHandler {
        public TracingEventHandler(TimerFactory factory, String name) {
            super(factory, name);
        }
    }
}

