/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.DispatchTargetsInfo;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.glassfish.logging.annotation.LogMessageInfo;

class AsyncContextImpl
implements AsyncContext {
    private static final String WELD_LISTENER = "org.jboss.weld.servlet.WeldListener";
    private static final Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    @LogMessageInfo(message="Unable to determine target of zero-arg dispatcher", level="WARNING")
    public static final String UNABLE_DETERMINE_TARGET_OF_DISPATCHER = "AS-WEB-CORE-00021";
    @LogMessageInfo(message="Unable to acquire RequestDispatcher for {0}", level="WARNING")
    public static final String UNABLE_ACQUIRE_REQUEST_DISPATCHER = "AS-WEB-CORE-00022";
    @LogMessageInfo(message="Unable to acquire RequestDispatcher for {0} in servlet context {1}", level="WARNING")
    public static final String UNABLE_ACQUIRE_REQUEST_DISPATCHER_IN_SERVLET_CONTEXT = "AS-WEB-CORE-00023";
    @LogMessageInfo(message="Error invoking AsyncListener", level="WARNING")
    public static final String ERROR_INVOKE_ASYNCLISTENER = "AS-WEB-CORE-00024";
    @LogMessageInfo(message="Asynchronous dispatch already in progress, must call ServletRequest.startAsync first", level="WARNING")
    public static final String ASYNC_DISPATCH_ALREADY_IN_PROGRESS_EXCEPTION = "AS-WEB-CORE-00025";
    @LogMessageInfo(message="Must not call AsyncContext.addListener after the container-initiated dispatch during which ServletRequest.startAsync was called has returned to the container", level="WARNING")
    public static final String ASYNC_CONTEXT_ADD_LISTENER_EXCEPTION = "AS-WEB-CORE-00026";
    @LogMessageInfo(message="Must not call AsyncContext.setTimeout after the container-initiated dispatch during which ServletRequest.startAsync was called has returned to the container", level="WARNING")
    public static final String ASYNC_CONTEXT_SET_TIMEOUT_EXCEPTION = "AS-WEB-CORE-00027";
    private static final long DEFAULT_ASYNC_TIMEOUT_MILLIS = 30000L;
    private static final ExecutorService pool = Executors.newCachedThreadPool(new AsyncPoolThreadFactory());
    private Request origRequest;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private boolean isOriginalRequestAndResponse = false;
    private boolean isStartAsyncWithZeroArg = false;
    private AtomicBoolean isDispatchInProgress = new AtomicBoolean();
    private ThreadLocal<Boolean> isDispatchInScope = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private AtomicBoolean isOkToConfigure = new AtomicBoolean(true);
    private long asyncTimeoutMillis = 30000L;
    private final Queue<AsyncListener> listenerQueue = new ConcurrentLinkedQueue<AsyncListener>();
    private final LinkedList<AsyncListenerContext> asyncListenerContexts = new LinkedList();
    private AtomicInteger startAsyncCounter = new AtomicInteger(0);
    private ThreadLocal<Boolean> isStartAsyncInScope = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private Handler handler = null;

    AsyncContextImpl(Request origRequest, ServletRequest servletRequest, Response origResponse, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.origRequest = origRequest;
        this.init(servletRequest, servletResponse, isStartAsyncWithZeroArg);
    }

    @Override
    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    Request getOriginalRequest() {
        return this.origRequest;
    }

    @Override
    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    @Override
    public boolean hasOriginalRequestAndResponse() {
        return this.isOriginalRequestAndResponse;
    }

    @Override
    public void dispatch() {
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.getZeroArgDispatcher(this.origRequest, this.servletRequest, this.isStartAsyncWithZeroArg);
        this.dispatch(dispatcher, null, null);
    }

    @Override
    public void dispatch(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(path);
        this.dispatch(dispatcher, null, path);
    }

    @Override
    public void dispatch(ServletContext context, String path) {
        if (path == null || context == null) {
            throw new IllegalArgumentException("Null context or path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)context.getRequestDispatcher(path);
        this.dispatch(dispatcher, context, path);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatch(ApplicationDispatcher dispatcher, ServletContext context, String path) {
        this.isDispatchInScope.set(true);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) {
                String msg = rb.getString(ASYNC_DISPATCH_ALREADY_IN_PROGRESS_EXCEPTION);
                throw new IllegalStateException(msg);
            }
            if (this.origRequest.isDelayAsyncDispatchAndComplete()) {
                this.handler = new Handler(this, dispatcher);
                return;
            }
            pool.execute(new Handler(this, dispatcher));
            return;
        }
        if (context == null && path == null) {
            log.log(Level.WARNING, UNABLE_DETERMINE_TARGET_OF_DISPATCHER);
            return;
        }
        if (context == null && path != null) {
            log.log(Level.WARNING, UNABLE_ACQUIRE_REQUEST_DISPATCHER, path);
            return;
        }
        log.log(Level.WARNING, UNABLE_ACQUIRE_REQUEST_DISPATCHER_IN_SERVLET_CONTEXT, new Object[]{path, context.getContextPath()});
    }

    void invokeDelayDispatch() {
        if (this.handler != null) {
            pool.execute(this.handler);
            this.handler = null;
        }
    }

    boolean isDispatchInScope() {
        return this.isDispatchInScope.get();
    }

    boolean getAndResetDispatchInScope() {
        boolean flag = this.isDispatchInScope.get();
        this.isDispatchInScope.set(Boolean.FALSE);
        return flag;
    }

    @Override
    public void complete() {
        this.origRequest.asyncComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Runnable run) {
        PrivilegedAction<ClassLoader> pa;
        ClassLoader oldCL = null;
        if (Globals.IS_SECURITY_ENABLED) {
            pa = new PrivilegedGetTccl();
            oldCL = AccessController.doPrivileged(pa);
        } else {
            oldCL = Thread.currentThread().getContextClassLoader();
        }
        try {
            ClassLoader newCL = this.origRequest.getContext().getLoader().getClassLoader();
            if (Globals.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl pa2 = new PrivilegedSetTccl(newCL);
                AccessController.doPrivileged(pa2);
            } else {
                Thread.currentThread().setContextClassLoader(newCL);
            }
            pool.execute(run);
        }
        finally {
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedSetTccl(oldCL);
                AccessController.doPrivileged(pa);
            } else {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }

    @Override
    public void addListener(AsyncListener listener) {
        this.addListener(listener, this.servletRequest, this.servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        if (servletRequest == null || servletResponse == null) {
            throw new IllegalArgumentException("Null request, or response");
        }
        if (!this.isOkToConfigure.get()) {
            String msg = rb.getString(ASYNC_CONTEXT_ADD_LISTENER_EXCEPTION);
            throw new IllegalStateException(msg);
        }
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.add(new AsyncListenerContext(listener, servletRequest, servletResponse));
        }
    }

    @Override
    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        AsyncListener listener = null;
        StandardContext ctx = (StandardContext)this.origRequest.getContext();
        if (ctx != null) {
            try {
                listener = (AsyncListener)ctx.createListenerInstance(clazz);
                this.listenerQueue.add(listener);
            }
            catch (Throwable t) {
                throw new ServletException(t);
            }
        }
        return (T)listener;
    }

    @Override
    public void setTimeout(long timeout) {
        if (!this.isOkToConfigure.get()) {
            String msg = rb.getString(ASYNC_CONTEXT_SET_TIMEOUT_EXCEPTION);
            throw new IllegalStateException(msg);
        }
        this.asyncTimeoutMillis = timeout;
    }

    @Override
    public long getTimeout() {
        return this.asyncTimeoutMillis;
    }

    void reinitialize(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.init(servletRequest, servletResponse, isStartAsyncWithZeroArg);
        this.isDispatchInProgress.set(false);
        this.setOkToConfigure(true);
        this.startAsyncCounter.incrementAndGet();
        this.notifyAsyncListeners(AsyncEventType.START_ASYNC, null);
    }

    boolean isOkToConfigure() {
        return this.isOkToConfigure.get();
    }

    void setOkToConfigure(boolean value) {
        this.isOkToConfigure.set(value);
    }

    private void init(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.isOriginalRequestAndResponse = !(!(servletRequest instanceof RequestFacade) && !(servletRequest instanceof ApplicationHttpRequest) || !(servletResponse instanceof ResponseFacade) && !(servletResponse instanceof ApplicationHttpResponse));
        this.isStartAsyncWithZeroArg = isStartAsyncWithZeroArg;
    }

    private RequestDispatcher getZeroArgDispatcher(Request origRequest, ServletRequest servletRequest, boolean isStartAsyncWithZeroArg) {
        String dispatchTarget = null;
        boolean isNamed = false;
        if (!isStartAsyncWithZeroArg && servletRequest instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            dispatchTarget = this.getCombinedPath(req);
        } else {
            DispatchTargetsInfo dtInfo = (DispatchTargetsInfo)origRequest.getAttribute("org.apache.catalina.core.ApplicationDispatcher.lastDispatchRequestPathAttr");
            if (dtInfo != null) {
                dispatchTarget = dtInfo.getLastDispatchTarget();
                isNamed = dtInfo.isLastNamedDispatchTarget();
            }
            if (dispatchTarget == null) {
                dispatchTarget = this.getCombinedPath(origRequest);
            }
        }
        RequestDispatcher dispatcher = null;
        if (dispatchTarget != null) {
            dispatcher = isNamed ? servletRequest.getServletContext().getNamedDispatcher(dispatchTarget) : servletRequest.getRequestDispatcher(dispatchTarget);
        }
        return dispatcher;
    }

    private String getCombinedPath(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        if (servletPath == null) {
            return null;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return servletPath;
        }
        return servletPath + pathInfo;
    }

    boolean isStartAsyncInScope() {
        return this.isStartAsyncInScope.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAsyncListeners(AsyncEventType asyncEventType, Throwable t) {
        ClassLoader oldCL;
        PrivilegedAction<ClassLoader> pa;
        LinkedList<AsyncListenerContext> clone;
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            if (this.asyncListenerContexts.isEmpty()) {
                return;
            }
            clone = new LinkedList<AsyncListenerContext>(this.asyncListenerContexts);
            if (asyncEventType.equals((Object)AsyncEventType.START_ASYNC)) {
                this.asyncListenerContexts.clear();
            }
        }
        if (Globals.IS_SECURITY_ENABLED) {
            pa = new PrivilegedGetTccl();
            oldCL = AccessController.doPrivileged(pa);
        } else {
            oldCL = Thread.currentThread().getContextClassLoader();
        }
        try {
            ServletRequestEvent event;
            ClassLoader newCL = this.origRequest.getContext().getLoader().getClassLoader();
            if (Globals.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl pa2 = new PrivilegedSetTccl(newCL);
                AccessController.doPrivileged(pa2);
            } else {
                Thread.currentThread().setContextClassLoader(newCL);
            }
            ServletRequestListener weldListener = this.getWeldListener();
            if (weldListener != null) {
                event = new ServletRequestEvent(this.origRequest.getContext().getServletContext(), this.origRequest);
                weldListener.requestInitialized(event);
            }
            try {
                for (AsyncListenerContext asyncListenerContext : clone) {
                    AsyncListener asyncListener = asyncListenerContext.getAsyncListener();
                    AsyncEvent asyncEvent = new AsyncEvent(this, asyncListenerContext.getRequest(), asyncListenerContext.getResponse(), t);
                    try {
                        switch (asyncEventType) {
                            case COMPLETE: {
                                asyncListener.onComplete(asyncEvent);
                                break;
                            }
                            case TIMEOUT: {
                                asyncListener.onTimeout(asyncEvent);
                                break;
                            }
                            case ERROR: {
                                asyncListener.onError(asyncEvent);
                                break;
                            }
                            case START_ASYNC: {
                                asyncListener.onStartAsync(asyncEvent);
                                break;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        log.log(Level.WARNING, ERROR_INVOKE_ASYNCLISTENER, throwable);
                    }
                }
            }
            finally {
                if (weldListener != null) {
                    event = new ServletRequestEvent(this.origRequest.getContext().getServletContext(), this.origRequest);
                    weldListener.requestDestroyed(event);
                }
            }
        }
        finally {
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedSetTccl(oldCL);
                AccessController.doPrivileged(pa);
            } else {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }

    private ServletRequestListener getWeldListener() {
        List<EventListener> eventListeners = this.origRequest.getContext().getApplicationEventListeners();
        if (eventListeners != null) {
            for (EventListener listener : eventListeners) {
                if (!listener.getClass().getName().equals(WELD_LISTENER)) continue;
                return (ServletRequestListener)listener;
            }
        }
        return null;
    }

    static ExecutorService getExecutorService() {
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.clear();
        }
        StandardContext ctx = (StandardContext)this.origRequest.getContext();
        if (ctx != null) {
            for (AsyncListener l : this.listenerQueue) {
                ctx.fireContainerEvent("predestroy", l);
            }
        }
        this.listenerQueue.clear();
        this.servletRequest = null;
        this.servletResponse = null;
        this.origRequest = null;
    }

    static enum AsyncEventType {
        COMPLETE,
        TIMEOUT,
        ERROR,
        START_ASYNC;

    }

    private static class AsyncListenerContext {
        private AsyncListener listener;
        private ServletRequest request;
        private ServletResponse response;

        public AsyncListenerContext(AsyncListener listener, ServletRequest request, ServletResponse response) {
            this.listener = listener;
            this.request = request;
            this.response = response;
        }

        public AsyncListener getAsyncListener() {
            return this.listener;
        }

        public ServletRequest getRequest() {
            return this.request;
        }

        public ServletResponse getResponse() {
            return this.response;
        }
    }

    private static final class AsyncPoolThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final AtomicInteger counter = new AtomicInteger(0);

        private AsyncPoolThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.defaultFactory.newThread(r);
            t.setName("glassfish-web-async-thread-" + this.counter.incrementAndGet());
            return t;
        }
    }

    static class Handler
    implements Runnable {
        private final AsyncContextImpl asyncContext;
        private final ApplicationDispatcher dispatcher;

        Handler(AsyncContextImpl asyncContext, ApplicationDispatcher dispatcher) {
            this.asyncContext = asyncContext;
            this.dispatcher = dispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.asyncContext.isStartAsyncInScope.set(Boolean.TRUE);
            Request origRequest = this.asyncContext.getOriginalRequest();
            origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.ASYNC);
            origRequest.setAsyncStarted(false);
            int startAsyncCurrent = this.asyncContext.startAsyncCounter.get();
            try {
                origRequest.setDelayAsyncDispatchAndComplete(true);
                this.dispatcher.dispatch(this.asyncContext.getRequest(), this.asyncContext.getResponse(), DispatcherType.ASYNC);
                origRequest.setDelayAsyncDispatchAndComplete(false);
                origRequest.processAsyncOperations();
                if (!origRequest.isAsyncComplete() && this.asyncContext.startAsyncCounter.compareAndSet(startAsyncCurrent, startAsyncCurrent)) {
                    this.asyncContext.complete();
                } else {
                    origRequest.setAsyncTimeout(this.asyncContext.getTimeout());
                }
            }
            catch (Throwable t) {
                origRequest.setDelayAsyncDispatchAndComplete(false);
                this.asyncContext.notifyAsyncListeners(AsyncEventType.ERROR, t);
                origRequest.errorDispatchAndComplete(t);
            }
            finally {
                this.asyncContext.isStartAsyncInScope.set(Boolean.FALSE);
            }
        }
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static class PrivilegedSetTccl
    implements PrivilegedAction<Void> {
        private ClassLoader cl;

        PrivilegedSetTccl(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.cl);
            return null;
        }
    }
}

