/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.ajp;

import java.io.IOException;
import java.util.Properties;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.ajp.AjpHttpRequest;
import org.glassfish.grizzly.http.ajp.AjpMessageUtils;
import org.glassfish.grizzly.http.ajp.ShutdownHandler;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.DataStructures;

public class AjpHandlerFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(AjpHandlerFilter.class);
    private final Attribute<AjpHttpRequest> httpRequestInProcessAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(HttpServerFilter.HTTP_SERVER_REQUEST_ATTR_NAME);
    private String secret;
    private boolean isTomcatAuthentication = true;
    private final Buffer NEED_MORE_DATA_MESSAGE = Buffers.cloneBuffer((Buffer)Buffers.EMPTY_BUFFER);
    private final Queue<ShutdownHandler> shutdownHandlers = DataStructures.getLTQInstance(ShutdownHandler.class);

    public void configure(Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty("request.useSecret"))) {
            this.secret = Double.toString(Math.random());
        }
        this.secret = properties.getProperty("request.secret", this.secret);
        this.isTomcatAuthentication = Boolean.parseBoolean(properties.getProperty("tomcatAuthentication", "true"));
    }

    public boolean isTomcatAuthentication() {
        return this.isTomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean isTomcatAuthentication) {
        this.isTomcatAuthentication = isTomcatAuthentication;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String requiredSecret) {
        this.secret = requiredSecret;
    }

    public void addShutdownHandler(ShutdownHandler handler) {
        this.shutdownHandlers.add(handler);
    }

    public void removeShutdownHandler(ShutdownHandler handler) {
        this.shutdownHandlers.remove(handler);
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer message = (Buffer)ctx.getMessage();
        if (message == this.NEED_MORE_DATA_MESSAGE) {
            this.sendMoreDataRequestIfNeeded(ctx);
            return ctx.getStopAction();
        }
        int type = this.extractType(ctx, message);
        switch (type) {
            case 2: {
                return this.processForwardRequest(ctx, message);
            }
            case 99: {
                return this.processData(ctx, message);
            }
            case 7: {
                return this.processShutdown(ctx, message);
            }
            case 10: {
                return this.processCPing(ctx, message);
            }
        }
        throw new IllegalStateException("Unknown message " + type);
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        HttpPacket httpPacket = (HttpPacket)ctx.getMessage();
        Buffer encodedPacket = this.encodeHttpPacket(connection, httpPacket);
        ctx.setMessage((Object)encodedPacket);
        return ctx.getInvokeAction();
    }

    private Buffer encodeHttpPacket(Connection connection, HttpPacket httpPacket) {
        HttpContent httpContentPacket;
        Buffer contentBuffer;
        MemoryManager memoryManager = connection.getTransport().getMemoryManager();
        boolean isHeader = httpPacket.isHeader();
        HttpHeader httpHeader = isHeader ? (HttpHeader)httpPacket : httpPacket.getHttpHeader();
        HttpResponsePacket httpResponsePacket = (HttpResponsePacket)httpHeader;
        Buffer encodedBuffer = null;
        if (!httpHeader.isCommitted()) {
            encodedBuffer = AjpMessageUtils.encodeHeaders(memoryManager, httpResponsePacket);
            if (httpResponsePacket.isAcknowledgement()) {
                encodedBuffer.trim();
                httpResponsePacket.acknowledged();
                return encodedBuffer;
            }
            httpHeader.setCommitted(true);
        }
        if (!isHeader && (contentBuffer = (httpContentPacket = (HttpContent)httpPacket).getContent()).hasRemaining()) {
            return AjpMessageUtils.appendContentAndTrim(memoryManager, encodedBuffer, contentBuffer);
        }
        assert (encodedBuffer != null);
        encodedBuffer.trim();
        return encodedBuffer;
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        HttpContext context;
        Connection c = ctx.getConnection();
        if (event.type() == HttpServerFilter.RESPONSE_COMPLETE_EVENT.type() && c.isOpen() && this.httpRequestInProcessAttr.remove((AttributeStorage)(context = HttpContext.get((FilterChainContext)ctx))) != null) {
            this.sendEndResponse(ctx);
        }
        return ctx.getStopAction();
    }

    private NextAction processData(FilterChainContext ctx, Buffer messageContent) {
        AjpHttpRequest httpRequestPacket = (AjpHttpRequest)((Object)this.httpRequestInProcessAttr.get((AttributeStorage)ctx.getConnection()));
        httpRequestPacket.getProcessingState().getHttpContext().attach(ctx);
        if (messageContent.hasRemaining()) {
            messageContent.position(messageContent.position() + 2);
        }
        if (httpRequestPacket.isExpectContent()) {
            int contentBytesRemaining = httpRequestPacket.getContentBytesRemaining();
            if (contentBytesRemaining > 0) {
                httpRequestPacket.setContentBytesRemaining(contentBytesRemaining -= messageContent.remaining());
                if (contentBytesRemaining <= 0) {
                    httpRequestPacket.setExpectContent(false);
                }
            } else if (!messageContent.hasRemaining()) {
                httpRequestPacket.setExpectContent(false);
            }
        }
        HttpContent content = HttpContent.builder((HttpHeader)httpRequestPacket).content(messageContent).last(!httpRequestPacket.isExpectContent()).build();
        ctx.setMessage((Object)content);
        return ctx.getInvokeAction((Object)(httpRequestPacket.isExpectContent() ? this.NEED_MORE_DATA_MESSAGE : null));
    }

    private NextAction processForwardRequest(FilterChainContext ctx, Buffer content) throws IOException {
        String epSecret;
        Connection connection = ctx.getConnection();
        AjpHttpRequest httpRequestPacket = AjpHttpRequest.create();
        HttpContext httpContext = HttpContext.newInstance((AttributeStorage)connection, (OutputSink)connection, (Closeable)connection, (HttpRequestPacket)httpRequestPacket).attach(ctx);
        httpRequestPacket.setConnection(connection);
        httpRequestPacket.getProcessingState().setHttpContext(httpContext);
        AjpMessageUtils.decodeRequest(content, httpRequestPacket, this.isTomcatAuthentication);
        if (!(this.secret == null || (epSecret = httpRequestPacket.getSecret()) != null && this.secret.equals(epSecret))) {
            throw new IllegalStateException("Secret doesn't match");
        }
        this.httpRequestInProcessAttr.set((AttributeStorage)httpContext, (Object)httpRequestPacket);
        ctx.setMessage((Object)HttpContent.builder((HttpHeader)httpRequestPacket).build());
        long contentLength = httpRequestPacket.getContentLength();
        if (contentLength > 0L) {
            httpRequestPacket.setContentBytesRemaining((int)contentLength);
            httpRequestPacket.setExpectContent(true);
            return ctx.getStopAction();
        }
        if (contentLength < 0L) {
            httpRequestPacket.setExpectContent(true);
            return ctx.getInvokeAction((Object)this.NEED_MORE_DATA_MESSAGE);
        }
        httpRequestPacket.setExpectContent(false);
        return ctx.getInvokeAction();
    }

    private NextAction processCPing(FilterChainContext ctx, Buffer message) throws IOException {
        message.clear();
        message.put((byte)65);
        message.put((byte)66);
        message.putShort((short)1);
        message.put((byte)9);
        message.flip();
        ctx.write((Object)message);
        ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
        return ctx.getStopAction();
    }

    private NextAction processShutdown(FilterChainContext ctx, Buffer message) {
        String shutdownSecret = null;
        if (message.remaining() > 2) {
            int offset = message.position();
            DataChunk tmpDataChunk = DataChunk.newInstance();
            AjpMessageUtils.getBytesToDataChunk(message, offset, tmpDataChunk);
            shutdownSecret = tmpDataChunk.toString();
        }
        if (this.secret != null && this.secret.equals(shutdownSecret)) {
            throw new IllegalStateException("Secret doesn't match, no shutdown");
        }
        Connection connection = ctx.getConnection();
        for (ShutdownHandler handler : this.shutdownHandlers) {
            try {
                handler.onShutdown(connection);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception during ShutdownHandler execution", e);
            }
        }
        return ctx.getStopAction();
    }

    private void sendMoreDataRequestIfNeeded(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        HttpContext context = HttpContext.get((FilterChainContext)ctx);
        if (this.httpRequestInProcessAttr.isSet((AttributeStorage)context)) {
            MemoryManager mm = connection.getTransport().getMemoryManager();
            Buffer buffer = mm.allocate(7);
            buffer.put((byte)65);
            buffer.put((byte)66);
            buffer.putShort((short)3);
            buffer.put((byte)6);
            buffer.putShort((short)8186);
            buffer.flip();
            buffer.allowBufferDispose(true);
            ctx.write((Object)buffer);
        }
    }

    private void sendEndResponse(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        MemoryManager mm = connection.getTransport().getMemoryManager();
        Buffer buffer = mm.allocate(6);
        buffer.put((byte)65);
        buffer.put((byte)66);
        buffer.putShort((short)2);
        buffer.put((byte)5);
        buffer.put((byte)1);
        buffer.flip();
        buffer.allowBufferDispose(true);
        ctx.write((Object)buffer);
    }

    private int extractType(FilterChainContext ctx, Buffer buffer) {
        return !this.httpRequestInProcessAttr.isSet((AttributeStorage)ctx.getConnection()) ? buffer.get() & 0xFF : 99;
    }
}

