/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.nio.AbstractNIOConnectionDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorRunner;

public final class RoundRobinConnectionDistributor
extends AbstractNIOConnectionDistributor {
    private final Iterator it;

    public RoundRobinConnectionDistributor(NIOTransport transport) {
        this(transport, false, false);
    }

    public RoundRobinConnectionDistributor(NIOTransport transport, boolean useDedicatedAcceptor) {
        this(transport, useDedicatedAcceptor, false);
    }

    public RoundRobinConnectionDistributor(NIOTransport transport, boolean useDedicatedAcceptor, boolean isServerOnly) {
        super(transport);
        this.it = useDedicatedAcceptor ? (isServerOnly ? new ServDedicatedIterator() : new DedicatedIterator()) : (isServerOnly ? new ServSharedIterator() : new SharedIterator());
    }

    @Override
    public void registerChannel(SelectableChannel channel, int interestOps, Object attachment) throws IOException {
        this.transport.getSelectorHandler().registerChannel(this.it.next(), channel, interestOps, attachment);
    }

    @Override
    public void registerChannelAsync(SelectableChannel channel, int interestOps, Object attachment, CompletionHandler<RegisterChannelResult> completionHandler) {
        this.transport.getSelectorHandler().registerChannelAsync(this.it.next(), channel, interestOps, attachment, completionHandler);
    }

    @Override
    public void registerServiceChannelAsync(SelectableChannel channel, int interestOps, Object attachment, CompletionHandler<RegisterChannelResult> completionHandler) {
        this.transport.getSelectorHandler().registerChannelAsync(this.it.nextService(), channel, interestOps, attachment, completionHandler);
    }

    private final class DedicatedIterator
    implements Iterator {
        private final AtomicInteger counter = new AtomicInteger();

        private DedicatedIterator() {
        }

        @Override
        public SelectorRunner next() {
            SelectorRunner[] runners = RoundRobinConnectionDistributor.this.getTransportSelectorRunners();
            if (runners.length == 1) {
                return runners[0];
            }
            return runners[(this.counter.getAndIncrement() & Integer.MAX_VALUE) % (runners.length - 1) + 1];
        }

        @Override
        public SelectorRunner nextService() {
            return RoundRobinConnectionDistributor.this.getTransportSelectorRunners()[0];
        }
    }

    private static interface Iterator {
        public SelectorRunner next();

        public SelectorRunner nextService();
    }

    private final class ServDedicatedIterator
    implements Iterator {
        private int counter;

        private ServDedicatedIterator() {
        }

        @Override
        public SelectorRunner next() {
            SelectorRunner[] runners = RoundRobinConnectionDistributor.this.getTransportSelectorRunners();
            if (runners.length == 1) {
                return runners[0];
            }
            return runners[(this.counter++ & Integer.MAX_VALUE) % (runners.length - 1) + 1];
        }

        @Override
        public SelectorRunner nextService() {
            return RoundRobinConnectionDistributor.this.getTransportSelectorRunners()[0];
        }
    }

    private final class ServSharedIterator
    implements Iterator {
        private int counter;

        private ServSharedIterator() {
        }

        @Override
        public SelectorRunner next() {
            SelectorRunner[] runners = RoundRobinConnectionDistributor.this.getTransportSelectorRunners();
            if (runners.length == 1) {
                return runners[0];
            }
            return runners[(this.counter++ & Integer.MAX_VALUE) % runners.length];
        }

        @Override
        public SelectorRunner nextService() {
            return this.next();
        }
    }

    private final class SharedIterator
    implements Iterator {
        private final AtomicInteger counter = new AtomicInteger();

        private SharedIterator() {
        }

        @Override
        public SelectorRunner next() {
            SelectorRunner[] runners = RoundRobinConnectionDistributor.this.getTransportSelectorRunners();
            if (runners.length == 1) {
                return runners[0];
            }
            return runners[(this.counter.getAndIncrement() & Integer.MAX_VALUE) % runners.length];
        }

        @Override
        public SelectorRunner nextService() {
            return this.next();
        }
    }
}

