/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.embeddable;

import com.sun.enterprise.admin.cli.embeddable.CommandExecutorImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.InternalSystemAdministrator;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
@ContractsProvided(value={DeployerImpl.class, Deployer.class})
public class DeployerImpl
implements Deployer {
    private static final Logger logger = Logger.getLogger(DeployerImpl.class.getPackage().getName());
    @Inject
    ServiceLocator habitat;
    @Inject
    private InternalSystemAdministrator kernelIdentity;

    public String deploy(URI archive, String ... params) throws GlassFishException {
        File file;
        try {
            file = this.convertToFile(archive);
        }
        catch (IOException e) {
            throw new GlassFishException("Unable to make a file out of " + archive, (Throwable)e);
        }
        return this.deploy(file, params);
    }

    public String deploy(File file, String ... params) throws GlassFishException {
        String[] newParams = new String[params.length + 1];
        System.arraycopy(params, 0, newParams, 0, params.length);
        newParams[params.length] = file.getAbsolutePath();
        CommandExecutorImpl executer = this.habitat.getService(CommandExecutorImpl.class, new Annotation[0]);
        try {
            File retrieve;
            String command = "deploy";
            ActionReport actionReport = executer.createActionReport();
            ParameterMap commandParams = executer.getParameters(command, newParams);
            CommandRunner.CommandInvocation inv = executer.getCommandRunner().getCommandInvocation(command, actionReport, this.kernelIdentity.getSubject());
            inv.parameters(commandParams);
            PayloadImpl.Outbound outboundPayload = null;
            String retrieveOpt = (String)commandParams.getOne((Object)"retrieve");
            File file2 = retrieve = retrieveOpt != null ? new File(retrieveOpt) : null;
            if (retrieve != null && retrieve.exists()) {
                outboundPayload = PayloadImpl.Outbound.newInstance();
                inv.outbound((Payload.Outbound)outboundPayload);
            }
            inv.execute();
            if (outboundPayload != null) {
                this.extractPayload((Payload.Outbound)outboundPayload, actionReport, retrieve);
            }
            return (String)actionReport.getResultType(String.class);
        }
        catch (CommandException e) {
            throw new GlassFishException((Throwable)e);
        }
    }

    public String deploy(InputStream is, String ... params) throws GlassFishException {
        try {
            return this.deploy(this.createFile(is), params);
        }
        catch (IOException e) {
            throw new GlassFishException((Throwable)e);
        }
    }

    public void undeploy(String appName, String ... params) throws GlassFishException {
        String[] newParams = new String[params.length + 1];
        System.arraycopy(params, 0, newParams, 0, params.length);
        newParams[params.length] = appName;
        CommandExecutorImpl executer = this.habitat.getService(CommandExecutorImpl.class, new Annotation[0]);
        try {
            ActionReport actionReport = executer.executeCommand("undeploy", newParams);
            actionReport.writeReport((OutputStream)System.out);
        }
        catch (CommandException e) {
            throw new GlassFishException((Throwable)e);
        }
        catch (IOException e) {
            throw new GlassFishException((Throwable)e);
        }
    }

    public Collection<String> getDeployedApplications() throws GlassFishException {
        try {
            CommandExecutorImpl executer = this.habitat.getService(CommandExecutorImpl.class, new Annotation[0]);
            ActionReport report = executer.executeCommand("list-components", new String[0]);
            Properties props = report.getTopMessagePart().getProps();
            return new ArrayList<String>(props.stringPropertyNames());
        }
        catch (Exception e) {
            throw new GlassFishException((Throwable)e);
        }
    }

    private File convertToFile(URI archive) throws IOException {
        File file = "file".equalsIgnoreCase(archive.getScheme()) ? new File(archive) : this.createFile(archive.toURL().openStream());
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFile(InputStream in) throws IOException {
        File file = File.createTempFile("app", "tmp");
        file.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.copyStream(in, out);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        return file;
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractPayload(Payload.Outbound outboundPayload, ActionReport actionReport, File retrieveDir) {
        File payloadZip = null;
        FileOutputStream payloadOutputStream = null;
        FileInputStream payloadInputStream = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            actionReport.writeReport((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            Properties reportProps = new Properties();
            reportProps.setProperty("data-request-type", "report");
            outboundPayload.addPart(0, actionReport.getContentType(), "report", reportProps, (InputStream)bais);
            payloadZip = File.createTempFile("appclient", ".zip");
            payloadOutputStream = new FileOutputStream(payloadZip);
            outboundPayload.writeTo((OutputStream)payloadOutputStream);
            payloadOutputStream.flush();
            payloadOutputStream.close();
            PayloadFilesManager.Perm pfm = new PayloadFilesManager.Perm(retrieveDir, null, logger);
            payloadInputStream = new FileInputStream(payloadZip);
            PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance((String)"application/zip", (InputStream)payloadInputStream);
            pfm.processParts((Payload.Inbound)inboundPayload);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        finally {
            if (payloadOutputStream != null) {
                try {
                    payloadOutputStream.close();
                }
                catch (IOException ioex) {
                    logger.warning(ioex.getMessage());
                }
            }
            if (payloadInputStream != null) {
                try {
                    payloadInputStream.close();
                }
                catch (IOException ioex) {
                    logger.warning(ioex.getMessage());
                }
            }
            if (payloadZip != null && !payloadZip.delete()) {
                logger.log(Level.WARNING, "Cannot delete payload: {0}", payloadZip.toString());
            }
        }
    }
}

