/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.util.LogFacade;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.naming.NamingException;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamespacePrefixes;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;

public class NamedNamingObjectManager {
    private static final AtomicReference<ServiceLocator> habitatRef = new AtomicReference();
    private static final Map<String, NamedNamingObjectProxy> proxies = new HashMap<String, NamedNamingObjectProxy>();
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAndLoadProxies(ServiceLocator habitat) throws NamingException {
        if (habitatRef.get() != habitat && habitat != null) {
            rwLock.writeLock().lock();
            try {
                if (habitatRef.get() != habitat) {
                    habitatRef.set(habitat);
                    proxies.clear();
                }
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
    }

    public static Object tryNamedProxies(String name) throws NamingException {
        NamedNamingObjectProxy proxy = NamedNamingObjectManager.getCachedProxy(name);
        if (proxy != null) {
            if (LogFacade.logger.isLoggable(Level.FINE)) {
                LogFacade.logger.logp(Level.FINE, "NamedNamingObjectManager", "tryNamedProxies", "found cached proxy [{0}] for [{1}]", new Object[]{proxy, name});
            }
            return proxy.handle(name);
        }
        for (ServiceHandle<NamespacePrefixes> inhabitant : NamedNamingObjectManager.getHabitat().getAllServiceHandles(NamespacePrefixes.class, new Annotation[0])) {
            List<String> prefixes = inhabitant.getActiveDescriptor().getMetadata().get("NamespacePrefixes");
            if (prefixes == null) continue;
            String prefix = null;
            for (String candidate : prefixes) {
                if (!name.startsWith(candidate)) continue;
                prefix = candidate;
                break;
            }
            if (prefix == null) continue;
            proxy = (NamedNamingObjectProxy)inhabitant.getService();
            if (LogFacade.logger.isLoggable(Level.FINE)) {
                LogFacade.logger.logp(Level.FINE, "NamedNamingObjectManager", "tryNamedProxies", "found a new proxy [{0}] for [{1}]", new Object[]{proxy, name});
            }
            NamedNamingObjectManager.cacheProxy(prefix, proxy);
            return proxy.handle(name);
        }
        return null;
    }

    private static ServiceLocator getHabitat() {
        return habitatRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NamedNamingObjectProxy getCachedProxy(String name) {
        rwLock.readLock().lock();
        try {
            for (String proxyPrefix : proxies.keySet()) {
                if (!name.startsWith(proxyPrefix)) continue;
                NamedNamingObjectProxy namedNamingObjectProxy = proxies.get(proxyPrefix);
                return namedNamingObjectProxy;
            }
        }
        finally {
            rwLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheProxy(String prefix, NamedNamingObjectProxy proxy) {
        rwLock.writeLock().lock();
        try {
            proxies.put(prefix, proxy);
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }
}

