/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.utils.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class TreePath
implements Serializable {
    private TreePath parentPath;
    private transient Object lastPathComponent;

    public TreePath(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("path in TreePath must be non null and not empty.");
        }
        this.lastPathComponent = objectArray[objectArray.length - 1];
        if (objectArray.length > 1) {
            this.parentPath = new TreePath(objectArray, objectArray.length - 1);
        }
    }

    public TreePath(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.lastPathComponent = object;
        this.parentPath = null;
    }

    protected TreePath(TreePath treePath, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.parentPath = treePath;
        this.lastPathComponent = object;
    }

    protected TreePath(Object[] objectArray, int n) {
        this.lastPathComponent = objectArray[n - 1];
        if (n > 1) {
            this.parentPath = new TreePath(objectArray, n - 1);
        }
    }

    protected TreePath() {
    }

    public Object[] getPath() {
        int n = this.getPathCount();
        Object[] objectArray = new Object[n--];
        TreePath treePath = this;
        while (treePath != null) {
            objectArray[n--] = treePath.lastPathComponent;
            treePath = treePath.parentPath;
        }
        return objectArray;
    }

    public Object getLastPathComponent() {
        return this.lastPathComponent;
    }

    public int getPathCount() {
        int n = 0;
        TreePath treePath = this;
        while (treePath != null) {
            ++n;
            treePath = treePath.parentPath;
        }
        return n;
    }

    public Object getPathComponent(int n) {
        int n2 = this.getPathCount();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Index " + n + " is out of the specified range");
        }
        TreePath treePath = this;
        for (int i = n2 - 1; i != n; --i) {
            treePath = treePath.parentPath;
        }
        return treePath.lastPathComponent;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TreePath) {
            TreePath treePath = (TreePath)object;
            if (this.getPathCount() != treePath.getPathCount()) {
                return false;
            }
            TreePath treePath2 = this;
            while (treePath2 != null) {
                if (!treePath2.lastPathComponent.equals(treePath.lastPathComponent)) {
                    return false;
                }
                treePath = treePath.parentPath;
                treePath2 = treePath2.parentPath;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.lastPathComponent.hashCode();
    }

    public boolean isDescendant(TreePath treePath) {
        if (treePath == this) {
            return true;
        }
        if (treePath != null) {
            int n = this.getPathCount();
            int n2 = treePath.getPathCount();
            if (n2 < n) {
                return false;
            }
            while (n2-- > n) {
                treePath = treePath.getParentPath();
            }
            return this.equals(treePath);
        }
        return false;
    }

    public TreePath pathByAddingChild(Object object) {
        if (object == null) {
            throw new NullPointerException("Null child not allowed");
        }
        return new TreePath(this, object);
    }

    public TreePath getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = this.getPathCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getPathComponent(i));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Vector<Object> vector = new Vector<Object>();
        boolean bl = true;
        if (this.lastPathComponent != null && this.lastPathComponent instanceof Serializable) {
            vector.addElement("lastPathComponent");
            vector.addElement(this.lastPathComponent);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("lastPathComponent")) {
            this.lastPathComponent = vector.elementAt(++n);
            ++n;
        }
    }
}

