/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class MergeID3AndMP3Files {
    private static int count = 0;
    private static int failed = 0;

    public static void main(String[] stringArray) {
        File file;
        MergeID3AndMP3Files mergeID3AndMP3Files = new MergeID3AndMP3Files();
        if (stringArray.length == 0) {
            System.err.println("usage MergeID3AndMP3Files FromDir ToDir mp3File");
            System.err.println("      You must enter the from dir,outputdir and the mp3file to append");
            System.exit(1);
        } else if (stringArray.length != 3) {
            System.err.println("usage MergeID3AndMP3Files FromDir ToDir mp3File");
            System.err.println("      Only three parameters accepted");
            System.exit(1);
        }
        File file2 = new File(stringArray[0]);
        if (!file2.isDirectory()) {
            System.err.println("usage MergeID3AndMP3Files FromDir ToDir mp3File");
            System.err.println("      Directory " + stringArray[0] + " could not be found");
            System.exit(1);
        }
        File file3 = new File(stringArray[1]);
        if (!file2.isDirectory()) {
            System.err.println("usage MergeID3AndMP3Files FromDir ToDir mp3File");
            System.err.println("      Directory " + stringArray[1] + " could not be found");
            System.exit(1);
        }
        if (!(file = new File(stringArray[2])).isFile()) {
            System.err.println("usage MergeID3AndMP3Files FromDir ToDir mp3File");
            System.err.println("      Mp3File " + stringArray[2] + " could not be found");
            System.exit(1);
        }
        Date date = new Date();
        System.out.println("Started to merge from:" + file2.getPath() + " at " + DateFormat.getTimeInstance().format(date));
        mergeID3AndMP3Files.scanSingleDir(file2, file3, file);
        Date date2 = new Date();
        System.out.println("Finished to merge from:" + file2.getPath() + DateFormat.getTimeInstance().format(date2));
        System.out.println("Attempted  to merge:" + count);
        System.out.println("Successful to merge:" + (count - failed));
        System.out.println("Failed     to merge:" + failed);
    }

    private void scanSingleDir(File file, File file2, File file3) {
        File[] fileArray;
        File[] fileArray2 = file.listFiles(new MP3FileFilter());
        if (fileArray2.length > 0) {
            fileArray = fileArray2;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file4 = fileArray[i];
                ++count;
                try {
                    MergeID3AndMP3Files.copyAudioToTmp(file2, file4, file3);
                    continue;
                }
                catch (Throwable throwable) {
                    System.err.println("Unable to merge record:" + count + ":" + file3.getPath());
                    ++failed;
                    throwable.printStackTrace();
                }
            }
        }
        if ((fileArray = file.listFiles(new DirFilter())).length > 0) {
            for (File file5 : fileArray) {
                this.scanSingleDir(file5, new File(file2, file5.getName()), file3);
            }
        }
    }

    public static File copyAudioToTmp(File file, File file2, File file3) {
        File file4 = new File(file.getPath(), file2.getName());
        boolean bl = MergeID3AndMP3Files.append(file2, file3, file4);
        return file4;
    }

    private static boolean append(File file, File file2, File file3) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            file3.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(fileInputStream2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            while ((n = bufferedInputStream.read()) > -1) {
                bufferedOutputStream.write(n);
            }
            while ((n = bufferedInputStream2.read()) > -1) {
                bufferedOutputStream.write(n);
            }
            bufferedOutputStream.close();
            bufferedInputStream.close();
            bufferedInputStream2.close();
            fileOutputStream.close();
            fileInputStream.close();
            fileInputStream2.close();
            if (file.length() + file2.length() != file3.length()) {
                file3.delete();
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public final class DirFilter
    implements FileFilter {
        public static final String IDENT = "$Id: MergeID3AndMP3Files.java 836 2009-11-12 15:44:07Z paultaylor $";

        @Override
        public final boolean accept(File file) {
            return file.isDirectory();
        }
    }

    final class MP3FileFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        private final boolean allowDirectories;

        public MP3FileFilter() {
            this(false);
        }

        private MP3FileFilter(boolean bl) {
            this.allowDirectories = bl;
        }

        @Override
        public final boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".mp3") || file.isDirectory() && this.allowDirectories;
        }

        @Override
        public final String getDescription() {
            return ".mp3 Files";
        }
    }
}

