/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.vorbiscomment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.jaudiotagger.audio.generic.AbstractTagCreator;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentFieldKey;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class VorbisCommentCreator
extends AbstractTagCreator {
    @Override
    public ByteBuffer convert(Tag tag, int n) throws UnsupportedEncodingException {
        try {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string = ((VorbisCommentTag)tag).getVendor();
            int n2 = Utils.getUTF8Bytes(string).length;
            byteArrayOutputStream.write(Utils.getSizeLEInt32(n2));
            byteArrayOutputStream.write(Utils.getUTF8Bytes(string));
            int n3 = tag.getFieldCount() - 1;
            byteArrayOutputStream.write(Utils.getSizeLEInt32(n3));
            Iterator<TagField> iterator = tag.getFields();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object.getId().equals(VorbisCommentFieldKey.VENDOR.getFieldName())) continue;
                byteArrayOutputStream.write(object.getRawContent());
            }
            object = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            ((ByteBuffer)object).rewind();
            return object;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

