/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextField;

public class Mp4TagTextNumberField
extends Mp4TagTextField {
    public static final int NUMBER_LENGTH = 2;
    protected List<Short> numbers;

    public Mp4TagTextNumberField(String string, String string2) {
        super(string, string2);
    }

    public Mp4TagTextNumberField(String string, ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        super(string, byteBuffer);
    }

    @Override
    protected byte[] getDataBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (Short s : this.numbers) {
            try {
                byteArrayOutputStream.write(Utils.getSizeBEInt16(s));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void copyContent(TagField tagField) {
        if (tagField instanceof Mp4TagTextNumberField) {
            this.content = ((Mp4TagTextNumberField)tagField).getContent();
            this.numbers = ((Mp4TagTextNumberField)tagField).getNumbers();
        }
    }

    @Override
    public Mp4FieldType getFieldType() {
        return Mp4FieldType.IMPLICIT;
    }

    @Override
    protected void build(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        Mp4BoxHeader mp4BoxHeader = new Mp4BoxHeader(byteBuffer);
        Mp4DataBox mp4DataBox = new Mp4DataBox(mp4BoxHeader, byteBuffer);
        this.dataSize = mp4BoxHeader.getDataLength();
        this.content = mp4DataBox.getContent();
        this.numbers = mp4DataBox.getNumbers();
    }

    public List<Short> getNumbers() {
        return this.numbers;
    }
}

