/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public abstract class Mp4TagField
implements TagField {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.mp4");
    protected String id;
    protected Mp4BoxHeader parentHeader;

    protected Mp4TagField(String string) {
        this.id = string;
    }

    protected Mp4TagField(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        this.build(byteBuffer);
    }

    protected Mp4TagField(Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        this.parentHeader = mp4BoxHeader;
        this.build(byteBuffer);
    }

    protected Mp4TagField(String string, ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        this(string);
        this.build(byteBuffer);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void isBinary(boolean bl) {
    }

    @Override
    public boolean isCommon() {
        return this.id.equals(Mp4FieldKey.ARTIST.getFieldName()) || this.id.equals(Mp4FieldKey.ALBUM.getFieldName()) || this.id.equals(Mp4FieldKey.TITLE.getFieldName()) || this.id.equals(Mp4FieldKey.TRACK.getFieldName()) || this.id.equals(Mp4FieldKey.DAY.getFieldName()) || this.id.equals(Mp4FieldKey.COMMENT.getFieldName()) || this.id.equals(Mp4FieldKey.GENRE.getFieldName());
    }

    protected byte[] getIdBytes() {
        return Utils.getDefaultBytes(this.getId(), "ISO-8859-1");
    }

    protected abstract byte[] getDataBytes() throws UnsupportedEncodingException;

    public abstract Mp4FieldType getFieldType();

    protected abstract void build(ByteBuffer var1) throws UnsupportedEncodingException;

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        logger.fine("Getting Raw data for:" + this.getId());
        try {
            byte[] byArray = this.getRawContentDataOnly();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(Utils.getSizeBEInt32(8 + byArray.length));
            byteArrayOutputStream.write(Utils.getDefaultBytes(this.getId(), "ISO-8859-1"));
            byteArrayOutputStream.write(byArray);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public byte[] getRawContentDataOnly() throws UnsupportedEncodingException {
        logger.fine("Getting Raw data for:" + this.getId());
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = this.getDataBytes();
            byteArrayOutputStream.write(Utils.getSizeBEInt32(16 + byArray.length));
            byteArrayOutputStream.write(Utils.getDefaultBytes("data", "ISO-8859-1"));
            byteArrayOutputStream.write(new byte[]{0});
            byteArrayOutputStream.write(new byte[]{0, 0, (byte)this.getFieldType().getFileClassId()});
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 0});
            byteArrayOutputStream.write(byArray);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

