/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class TextEncodedStringNullTerminated
extends AbstractString {
    public TextEncodedStringNullTerminated(String string, AbstractTagFrameBody abstractTagFrameBody) {
        super(string, abstractTagFrameBody);
    }

    public TextEncodedStringNullTerminated(String string, AbstractTagFrameBody abstractTagFrameBody, String string2) {
        super(string, abstractTagFrameBody, string2);
    }

    public TextEncodedStringNullTerminated(TextEncodedStringNullTerminated textEncodedStringNullTerminated) {
        super(textEncodedStringNullTerminated);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof TextEncodedStringNullTerminated && super.equals(object);
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        if (n >= byArray.length) {
            throw new InvalidDataTypeException("Unable to find null terminated string");
        }
        logger.finer("Reading from array starting from offset:" + n);
        String string = this.getTextEncodingCharSet();
        CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, byArray.length - n);
        int n2 = 0;
        boolean bl = string.equals("ISO-8859-1") || string.equals("UTF-8");
        boolean bl2 = false;
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (by == 0) {
                if (bl) {
                    byteBuffer.mark();
                    byteBuffer.reset();
                    n2 = byteBuffer.position() - 1;
                    logger.finest("Null terminator found starting at:" + n2);
                    bl2 = true;
                    break;
                }
                if (byteBuffer.hasRemaining()) {
                    by = byteBuffer.get();
                    if (by != 0) continue;
                    byteBuffer.mark();
                    byteBuffer.reset();
                    n2 = byteBuffer.position() - 2;
                    logger.finest("UTF16:Null terminator found starting  at:" + n2);
                    bl2 = true;
                    break;
                }
                byteBuffer.mark();
                byteBuffer.reset();
                n2 = byteBuffer.position() - 1;
                logger.warning("UTF16:Should be two null terminator marks but only found one starting at:" + n2);
                bl2 = true;
                break;
            }
            if (bl || !byteBuffer.hasRemaining()) continue;
            byteBuffer.get();
        }
        if (!bl2) {
            throw new InvalidDataTypeException("Unable to find null terminated string");
        }
        logger.finest("End Position is:" + n2 + "Offset:" + n);
        int n3 = n2 - n;
        ++n3;
        if (!bl) {
            ++n3;
        }
        this.setSize(n3);
        int n4 = n2 - n;
        logger.finest("Text size is:" + n4);
        if (n4 == 0) {
            this.value = "";
        } else {
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray, n, n4).slice();
            CharBuffer charBuffer = CharBuffer.allocate(n4);
            charsetDecoder.reset();
            CoderResult coderResult = charsetDecoder.decode(byteBuffer2, charBuffer, true);
            if (coderResult.isError()) {
                logger.warning("Problem decoding text encoded null terminated string:" + coderResult.toString());
            }
            charsetDecoder.flush(charBuffer);
            charBuffer.flip();
            this.value = charBuffer.toString();
        }
        logger.config("Read NullTerminatedString:" + this.value + " size inc terminator:" + n3);
    }

    @Override
    public byte[] writeByteArray() {
        byte[] byArray;
        logger.config("Writing NullTerminatedString." + this.value);
        try {
            String string = this.getTextEncodingCharSet();
            if (string.equals("UTF-16")) {
                if (TagOptionSingleton.getInstance().isEncodeUTF16BomAsLittleEndian()) {
                    string = "UTF-16LE";
                    CharsetEncoder charsetEncoder = Charset.forName(string).newEncoder();
                    ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap('\ufeff' + (String)this.value + '\u0000'));
                    byArray = new byte[byteBuffer.limit()];
                    byteBuffer.get(byArray, 0, byteBuffer.limit());
                } else {
                    string = "UTF-16BE";
                    CharsetEncoder charsetEncoder = Charset.forName(string).newEncoder();
                    ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap('\ufeff' + (String)this.value + '\u0000'));
                    byArray = new byte[byteBuffer.limit()];
                    byteBuffer.get(byArray, 0, byteBuffer.limit());
                }
            } else {
                CharsetEncoder charsetEncoder = Charset.forName(string).newEncoder();
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap((String)this.value + '\u0000'));
                byArray = new byte[byteBuffer.limit()];
                byteBuffer.get(byArray, 0, byteBuffer.limit());
            }
        }
        catch (CharacterCodingException characterCodingException) {
            logger.severe(characterCodingException.getMessage());
            throw new RuntimeException(characterCodingException);
        }
        this.setSize(byArray.length);
        return byArray;
    }

    protected String getTextEncodingCharSet() {
        byte by = this.getBody().getTextEncoding();
        String string = TextEncoding.getInstanceOf().getValueForId(by);
        logger.finest("text encoding:" + by + " charset:" + string);
        return string;
    }
}

