/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class StringFixedLength
extends AbstractString {
    public StringFixedLength(String string, AbstractTagFrameBody abstractTagFrameBody, int n) {
        super(string, abstractTagFrameBody);
        if (n < 0) {
            throw new IllegalArgumentException("size is less than zero: " + n);
        }
        this.setSize(n);
    }

    public StringFixedLength(StringFixedLength stringFixedLength) {
        super(stringFixedLength);
        this.size = stringFixedLength.size;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof StringFixedLength)) {
            return false;
        }
        StringFixedLength stringFixedLength = (StringFixedLength)object;
        return this.size == stringFixedLength.size && super.equals(object);
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        logger.config("Reading from array from offset:" + n);
        try {
            String string = this.getTextEncodingCharSet();
            CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
            logger.finest("Array length is:" + byArray.length + "offset is:" + n + "Size is:" + this.size);
            if (byArray.length - n < this.size) {
                throw new InvalidDataTypeException("byte array is to small to retrieve string of declared length:" + this.size);
            }
            String string2 = charsetDecoder.decode(ByteBuffer.wrap(byArray, n, this.size)).toString();
            if (string2 == null) {
                throw new NullPointerException("String is null");
            }
            this.value = string2;
        }
        catch (CharacterCodingException characterCodingException) {
            logger.severe(characterCodingException.getMessage());
            this.value = "";
        }
        logger.config("Read StringFixedLength:" + this.value);
    }

    @Override
    public byte[] writeByteArray() {
        ByteBuffer byteBuffer;
        if (this.value == null) {
            logger.warning("Value of StringFixedlength Field is null using default value instead");
            byte[] byArray = new byte[this.size];
            for (int i = 0; i < this.size; ++i) {
                byArray[i] = 32;
            }
            return byArray;
        }
        try {
            CharsetEncoder charsetEncoder;
            String string = this.getTextEncodingCharSet();
            if (string.equals("UTF-16")) {
                string = "UTF-16LE";
                charsetEncoder = Charset.forName(string).newEncoder();
                byteBuffer = charsetEncoder.encode(CharBuffer.wrap('\ufeff' + (String)this.value));
            } else {
                charsetEncoder = Charset.forName(string).newEncoder();
                byteBuffer = charsetEncoder.encode(CharBuffer.wrap((String)this.value));
            }
        }
        catch (CharacterCodingException characterCodingException) {
            logger.warning("There was a problem writing the following StringFixedlength Field:" + this.value + ":" + characterCodingException.getMessage() + "using default value instead");
            byte[] byArray = new byte[this.size];
            for (int i = 0; i < this.size; ++i) {
                byArray[i] = 32;
            }
            return byArray;
        }
        if (byteBuffer != null) {
            if (byteBuffer.limit() == this.size) {
                byte[] byArray = new byte[byteBuffer.limit()];
                byteBuffer.get(byArray, 0, byteBuffer.limit());
                return byArray;
            }
            if (byteBuffer.limit() > this.size) {
                logger.warning("There was a problem writing the following StringFixedlength Field:" + this.value + " when converted to bytes has length of:" + byteBuffer.limit() + " but field was defined with length of:" + this.size + " too long so stripping extra length");
                byte[] byArray = new byte[this.size];
                byteBuffer.get(byArray, 0, this.size);
                return byArray;
            }
            logger.warning("There was a problem writing the following StringFixedlength Field:" + this.value + " when converted to bytes has length of:" + byteBuffer.limit() + " but field was defined with length of:" + this.size + " too short so padding with spaces to make up extra length");
            byte[] byArray = new byte[this.size];
            byteBuffer.get(byArray, 0, byteBuffer.limit());
            for (int i = byteBuffer.limit(); i < this.size; ++i) {
                byArray[i] = 32;
            }
            return byArray;
        }
        logger.warning("There was a serious problem writing the following StringFixedlength Field:" + this.value + ":" + "using default value instead");
        byte[] byArray = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            byArray[i] = 32;
        }
        return byArray;
    }

    protected String getTextEncodingCharSet() {
        byte by = this.getBody().getTextEncoding();
        String string = TextEncoding.getInstanceOf().getValueForId(by);
        logger.finest("text encoding:" + by + " charset:" + string);
        return string;
    }
}

