/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.Iterator;
import java.util.LinkedList;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.datatype.ID3v2LyricLine;
import org.jaudiotagger.tag.datatype.Lyrics3TimeStamp;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class Lyrics3Line
extends AbstractDataType {
    private LinkedList<Lyrics3TimeStamp> timeStamp = new LinkedList();
    private String lyric = "";

    public Lyrics3Line(String string, AbstractTagFrameBody abstractTagFrameBody) {
        super(string, abstractTagFrameBody);
    }

    public Lyrics3Line(Lyrics3Line lyrics3Line) {
        super(lyrics3Line);
        this.lyric = lyrics3Line.lyric;
        for (int i = 0; i < lyrics3Line.timeStamp.size(); ++i) {
            Lyrics3TimeStamp lyrics3TimeStamp = new Lyrics3TimeStamp(lyrics3Line.timeStamp.get(i));
            this.timeStamp.add(lyrics3TimeStamp);
        }
    }

    public void setLyric(String string) {
        this.lyric = string;
    }

    public void setLyric(ID3v2LyricLine iD3v2LyricLine) {
        this.lyric = iD3v2LyricLine.getText();
    }

    public String getLyric() {
        return this.lyric;
    }

    @Override
    public int getSize() {
        int n = 0;
        for (Object e : this.timeStamp) {
            n += ((Lyrics3TimeStamp)e).getSize();
        }
        return n + this.lyric.length();
    }

    public void setTimeStamp(Lyrics3TimeStamp lyrics3TimeStamp) {
        this.timeStamp.clear();
        this.timeStamp.add(lyrics3TimeStamp);
    }

    public Iterator<Lyrics3TimeStamp> getTimeStamp() {
        return this.timeStamp.iterator();
    }

    public void addLyric(String string) {
        this.lyric = this.lyric + string;
    }

    public void addLyric(ID3v2LyricLine iD3v2LyricLine) {
        this.lyric = this.lyric + iD3v2LyricLine.getText();
    }

    public void addTimeStamp(Lyrics3TimeStamp lyrics3TimeStamp) {
        this.timeStamp.add(lyrics3TimeStamp);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Lyrics3Line)) {
            return false;
        }
        Lyrics3Line lyrics3Line = (Lyrics3Line)object;
        if (!this.lyric.equals(lyrics3Line.lyric)) {
            return false;
        }
        return this.timeStamp.equals(lyrics3Line.timeStamp) && super.equals(object);
    }

    public boolean hasTimeStamp() {
        return !this.timeStamp.isEmpty();
    }

    public void readString(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Image is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to line is out of bounds: offset = " + n + ", line.length()" + string.length());
        }
        this.timeStamp = new LinkedList();
        int n2 = string.indexOf("[", n);
        while (n2 >= 0) {
            n = string.indexOf("]", n2) + 1;
            Lyrics3TimeStamp lyrics3TimeStamp = new Lyrics3TimeStamp("Time Stamp");
            lyrics3TimeStamp.readString(string.substring(n2, n));
            this.timeStamp.add(lyrics3TimeStamp);
            n2 = string.indexOf("[", n);
        }
        this.lyric = string.substring(n);
    }

    public String toString() {
        String string = "";
        for (Object e : this.timeStamp) {
            string = string + e.toString();
        }
        return "timeStamp = " + string + ", lyric = " + this.lyric + "\n";
    }

    public String writeString() {
        String string = "";
        for (Object e : this.timeStamp) {
            Lyrics3TimeStamp lyrics3TimeStamp = (Lyrics3TimeStamp)e;
            string = string + lyrics3TimeStamp.writeString();
        }
        return string + this.lyric;
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        this.readString(byArray.toString(), n);
    }

    @Override
    public byte[] writeByteArray() {
        return Utils.getDefaultBytes(this.writeString(), "ISO8859-1");
    }
}

