/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.wav.util.WavFormatHeader;
import org.jaudiotagger.audio.wav.util.WavRIFFHeader;

public class WavInfoReader {
    public GenericAudioHeader read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        WavFormatHeader wavFormatHeader;
        GenericAudioHeader genericAudioHeader = new GenericAudioHeader();
        if (randomAccessFile.length() < 12L) {
            throw new CannotReadException("This is not a WAV File (<12 bytes)");
        }
        byte[] byArray = new byte[12];
        randomAccessFile.read(byArray);
        WavRIFFHeader wavRIFFHeader = new WavRIFFHeader(byArray);
        if (wavRIFFHeader.isValid()) {
            byArray = new byte[34];
            randomAccessFile.read(byArray);
            wavFormatHeader = new WavFormatHeader(byArray);
            if (!wavFormatHeader.isValid()) {
                throw new CannotReadException("Wav Format Header not valid");
            }
        } else {
            throw new CannotReadException("Wav RIFF Header not valid");
        }
        genericAudioHeader.setPreciseLength(((float)randomAccessFile.length() - 36.0f) / (float)wavFormatHeader.getBytesPerSecond());
        genericAudioHeader.setChannelNumber(wavFormatHeader.getChannelNumber());
        genericAudioHeader.setSamplingRate(wavFormatHeader.getSamplingRate());
        genericAudioHeader.setBitsPerSample(wavFormatHeader.getBitsPerSample());
        genericAudioHeader.setEncodingType("WAV-RIFF " + wavFormatHeader.getBitsPerSample() + " bits");
        genericAudioHeader.setExtraEncodingInfos("");
        genericAudioHeader.setBitrate(wavFormatHeader.getBytesPerSecond() * 8 / 1000);
        genericAudioHeader.setVariableBitRate(false);
        return genericAudioHeader;
    }
}

