/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.Mp4AtomTree;
import org.jaudiotagger.audio.mp4.atom.AbstractMp4Box;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4FreeBox;
import org.jaudiotagger.audio.mp4.atom.Mp4HdlrBox;
import org.jaudiotagger.audio.mp4.atom.Mp4MetaBox;
import org.jaudiotagger.audio.mp4.atom.Mp4StcoBox;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.mp4.Mp4TagCreator;
import org.jaudiotagger.utils.tree.DefaultMutableTreeNode;

public class Mp4TagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.mp4");
    private Mp4TagCreator tc = new Mp4TagCreator();

    private void writeMetadataSameSize(ByteBuffer byteBuffer, long l, long l2, FileChannel fileChannel, FileChannel fileChannel2, Mp4BoxHeader mp4BoxHeader) throws CannotWriteException, IOException {
        fileChannel.position(0L);
        fileChannel2.transferFrom(fileChannel, 0L, l2);
        fileChannel2.position(l2);
        fileChannel2.write(byteBuffer);
        fileChannel.position(l2 + l);
        this.writeDataAfterIlst(fileChannel, fileChannel2, mp4BoxHeader);
    }

    private void writeNeroData(FileChannel fileChannel, FileChannel fileChannel2, Mp4BoxHeader mp4BoxHeader) throws IOException, CannotWriteException {
        long l = mp4BoxHeader.getFilePos() - fileChannel.position();
        fileChannel2.transferFrom(fileChannel, fileChannel2.position(), l);
        fileChannel2.position(fileChannel2.position() + l);
        this.convertandWriteTagsAtomToFreeAtom(fileChannel2, mp4BoxHeader);
        fileChannel.position(mp4BoxHeader.getFilePos() + (long)mp4BoxHeader.getLength());
        this.writeDataInChunks(fileChannel, fileChannel2);
    }

    private void adjustSizeOfMoovHeader(Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer, int n, Mp4BoxHeader mp4BoxHeader2, Mp4BoxHeader mp4BoxHeader3) throws IOException {
        mp4BoxHeader.setLength(mp4BoxHeader.getLength() + n);
        if (mp4BoxHeader2 != null) {
            mp4BoxHeader2.setLength(mp4BoxHeader2.getLength() + n);
            byteBuffer.position((int)(mp4BoxHeader2.getFilePos() - mp4BoxHeader.getFilePos() - 8L));
            byteBuffer.put(mp4BoxHeader2.getHeaderData());
        }
        if (mp4BoxHeader3 != null) {
            mp4BoxHeader3.setLength(mp4BoxHeader3.getLength() + n);
            byteBuffer.position((int)(mp4BoxHeader3.getFilePos() - mp4BoxHeader.getFilePos() - 8L));
            byteBuffer.put(mp4BoxHeader3.getHeaderData());
        }
    }

    private void createMetadataAtoms(Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer, int n, Mp4BoxHeader mp4BoxHeader2, Mp4BoxHeader mp4BoxHeader3) throws IOException {
        mp4BoxHeader.setLength(mp4BoxHeader.getLength() + n);
    }

    /*
     * WARNING - void declaration
     */
    public void write(Tag tag, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotWriteException, IOException {
        Object object;
        int n;
        int n2;
        Mp4AtomTree mp4AtomTree;
        logger.config("Started writing tag data");
        FileChannel fileChannel = randomAccessFile.getChannel();
        FileChannel fileChannel2 = randomAccessFile2.getChannel();
        int n3 = 0;
        long l = 0L;
        try {
            mp4AtomTree = new Mp4AtomTree(randomAccessFile, false);
        }
        catch (CannotReadException cannotReadException) {
            throw new CannotWriteException(cannotReadException.getMessage());
        }
        Mp4BoxHeader mp4BoxHeader = mp4AtomTree.getBoxHeader(mp4AtomTree.getMdatNode());
        if (mp4BoxHeader == null) {
            throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_CANNOT_FIND_AUDIO.getMsg());
        }
        ByteBuffer byteBuffer = this.tc.convert(tag);
        byteBuffer.rewind();
        int n4 = byteBuffer.limit();
        Mp4BoxHeader mp4BoxHeader2 = mp4AtomTree.getBoxHeader(mp4AtomTree.getMoovNode());
        long l2 = mp4BoxHeader2.getFilePos() + 8L;
        l = mp4BoxHeader2.getFilePos() + (long)mp4BoxHeader2.getLength();
        Mp4StcoBox mp4StcoBox = mp4AtomTree.getStco();
        Mp4BoxHeader mp4BoxHeader3 = mp4AtomTree.getBoxHeader(mp4AtomTree.getIlstNode());
        Mp4BoxHeader mp4BoxHeader4 = mp4AtomTree.getBoxHeader(mp4AtomTree.getUdtaNode());
        Mp4BoxHeader mp4BoxHeader5 = mp4AtomTree.getBoxHeader(mp4AtomTree.getMetaNode());
        Mp4BoxHeader mp4BoxHeader6 = mp4AtomTree.getBoxHeader(mp4AtomTree.getHdlrWithinMetaNode());
        Mp4BoxHeader mp4BoxHeader7 = mp4AtomTree.getBoxHeader(mp4AtomTree.getTagsNode());
        Mp4BoxHeader mp4BoxHeader8 = mp4AtomTree.getBoxHeader(mp4AtomTree.getTrakNodes().get(0));
        ByteBuffer byteBuffer2 = mp4AtomTree.getMoovBuffer();
        if (mp4BoxHeader4 != null) {
            if (mp4BoxHeader5 != null) {
                if (mp4BoxHeader3 != null) {
                    n3 = mp4BoxHeader3.getLength();
                    n2 = (int)mp4BoxHeader3.getFilePos();
                    n = (int)((long)n2 - (mp4BoxHeader2.getFilePos() + 8L));
                } else if (mp4BoxHeader6 != null) {
                    n2 = (int)mp4BoxHeader6.getFilePos() + mp4BoxHeader6.getLength();
                    n = (int)((long)n2 - (mp4BoxHeader2.getFilePos() + 8L));
                } else {
                    n2 = (int)mp4BoxHeader5.getFilePos() + 8 + 4;
                    n = (int)((long)n2 - (mp4BoxHeader2.getFilePos() + 8L));
                }
            } else {
                n = mp4BoxHeader2.getLength() - 8;
                n2 = (int)(mp4BoxHeader2.getFilePos() + (long)mp4BoxHeader2.getLength());
            }
        } else if (mp4BoxHeader5 != null) {
            n2 = (int)mp4BoxHeader8.getFilePos() + mp4BoxHeader8.getLength();
            n = (int)((long)n2 - (mp4BoxHeader2.getFilePos() + 8L));
        } else {
            n = mp4BoxHeader2.getLength() - 8;
            n2 = (int)(mp4BoxHeader2.getFilePos() + (long)mp4BoxHeader2.getLength());
        }
        int n5 = this.getMetaLevelFreeAtomSize(mp4AtomTree);
        int n6 = 0;
        int n7 = 0;
        boolean bl = true;
        boolean bl2 = false;
        for (DefaultMutableTreeNode object2 : mp4AtomTree.getFreeNodes()) {
            object = (DefaultMutableTreeNode)object2.getParent();
            if (!((DefaultMutableTreeNode)object).isRoot()) continue;
            Mp4BoxHeader mp4BoxHeader9 = (Mp4BoxHeader)object2.getUserObject();
            n7 = mp4BoxHeader9.getLength();
            n6 = (int)mp4BoxHeader9.getFilePos();
            break;
        }
        if (n7 > 0) {
            if ((long)n6 > mp4BoxHeader.getFilePos()) {
                bl = false;
            } else if ((long)n6 < mp4BoxHeader2.getFilePos()) {
                bl = false;
                bl2 = true;
            }
        } else {
            n6 = (int)mp4BoxHeader.getFilePos();
        }
        logger.config("Read header successfully ready for writing");
        if (n3 == n4) {
            logger.config("Writing:Option 1:Same Size");
            this.writeMetadataSameSize(byteBuffer, n3, n2, fileChannel, fileChannel2, mp4BoxHeader7);
        } else if (n3 > n4) {
            if (n5 > 0) {
                logger.config("Writing:Option 2:Smaller Size have free atom:" + n3 + ":" + n4);
                this.writeDataUptoIncludingIlst(fileChannel, fileChannel2, n3, n2, byteBuffer);
                int n8 = n5 + (n3 - n4);
                Mp4FreeBox n10 = new Mp4FreeBox(n8 - 8);
                fileChannel2.write(n10.getHeader().getHeaderData());
                fileChannel2.write(n10.getData());
                fileChannel.position(fileChannel.position() + (long)n5);
                this.writeDataAfterIlst(fileChannel, fileChannel2, mp4BoxHeader7);
            } else {
                int n9 = n3 - n4 - 8;
                if (n9 > 0) {
                    logger.config("Writing:Option 3:Smaller Size can create free atom");
                    this.writeDataUptoIncludingIlst(fileChannel, fileChannel2, n3, n2, byteBuffer);
                    Mp4FreeBox n12 = new Mp4FreeBox(n9);
                    fileChannel2.write(n12.getHeader().getHeaderData());
                    fileChannel2.write(n12.getData());
                    this.writeDataAfterIlst(fileChannel, fileChannel2, mp4BoxHeader7);
                } else {
                    logger.config("Writing:Option 4:Smaller Size <=8 cannot create free atoms");
                    int n13 = n3 - n4;
                    fileChannel.position(0L);
                    fileChannel2.transferFrom(fileChannel, 0L, mp4BoxHeader2.getFilePos());
                    fileChannel2.position(mp4BoxHeader2.getFilePos());
                    if (mp4BoxHeader.getFilePos() > mp4BoxHeader2.getFilePos()) {
                        mp4StcoBox.adjustOffsets(-n13);
                    }
                    this.adjustSizeOfMoovHeader(mp4BoxHeader2, byteBuffer2, -n13, mp4BoxHeader4, mp4BoxHeader5);
                    fileChannel2.write(mp4BoxHeader2.getHeaderData());
                    byteBuffer2.rewind();
                    byteBuffer2.limit(n);
                    fileChannel2.write(byteBuffer2);
                    fileChannel2.write(byteBuffer);
                    fileChannel.position(n2 + n3);
                    this.writeDataAfterIlst(fileChannel, fileChannel2, mp4BoxHeader7);
                }
            }
        } else {
            int n11 = n4 - n3;
            if (n11 <= n5 - 8) {
                int n8 = n5 - n11;
                logger.config("Writing:Option 5;Larger Size can use meta free atom need extra:" + n8 + "bytes");
                this.writeDataUptoIncludingIlst(fileChannel, fileChannel2, n3, n2, byteBuffer);
                object = new Mp4FreeBox(n8 - 8);
                fileChannel2.write(((AbstractMp4Box)object).getHeader().getHeaderData());
                fileChannel2.write(((AbstractMp4Box)object).getData());
                fileChannel.position(fileChannel.position() + (long)n5);
                this.writeDataAfterIlst(fileChannel, fileChannel2, mp4BoxHeader7);
            } else {
                long l3;
                int n9 = n11 - n5;
                fileChannel.position(0L);
                fileChannel2.transferFrom(fileChannel, 0L, l2 - 8L);
                fileChannel2.position(l2 - 8L);
                if (mp4BoxHeader4 == null) {
                    logger.config("Writing:Option 5.1;No udta atom");
                    object = Mp4HdlrBox.createiTunesStyleHdlrBox();
                    Mp4MetaBox mp4MetaBox = Mp4MetaBox.createiTunesStyleMetaBox(((AbstractMp4Box)object).getHeader().getLength() + byteBuffer.limit());
                    mp4BoxHeader4 = new Mp4BoxHeader(Mp4AtomIdentifier.UDTA.getFieldName());
                    mp4BoxHeader4.setLength(8 + mp4MetaBox.getHeader().getLength());
                    int n10 = n9 + (mp4BoxHeader4.getLength() - byteBuffer.limit());
                    if ((!bl || n7 - 8 < n10 && n7 != n10) && mp4BoxHeader.getFilePos() > mp4BoxHeader2.getFilePos()) {
                        logger.config("Adjusting Offsets");
                        mp4StcoBox.adjustOffsets(n10);
                    }
                    mp4BoxHeader2.setLength(mp4BoxHeader2.getLength() + n10);
                    fileChannel2.write(mp4BoxHeader2.getHeaderData());
                    byteBuffer2.rewind();
                    byteBuffer2.limit(n);
                    fileChannel2.write(byteBuffer2);
                    fileChannel2.write(mp4BoxHeader4.getHeaderData());
                    fileChannel2.write(mp4MetaBox.getHeader().getHeaderData());
                    fileChannel2.write(mp4MetaBox.getData());
                    fileChannel2.write(((AbstractMp4Box)object).getHeader().getHeaderData());
                    fileChannel2.write(((AbstractMp4Box)object).getData());
                } else if (mp4BoxHeader5 == null) {
                    logger.config("Writing:Option 5.2;No meta atom");
                    int n12 = mp4BoxHeader4.getLength();
                    Mp4HdlrBox mp4HdlrBox = Mp4HdlrBox.createiTunesStyleHdlrBox();
                    Mp4MetaBox mp4MetaBox = Mp4MetaBox.createiTunesStyleMetaBox(mp4HdlrBox.getHeader().getLength() + byteBuffer.limit());
                    mp4BoxHeader4 = new Mp4BoxHeader(Mp4AtomIdentifier.UDTA.getFieldName());
                    mp4BoxHeader4.setLength(8 + mp4MetaBox.getHeader().getLength());
                    int n13 = n9 + (mp4BoxHeader4.getLength() - byteBuffer.limit());
                    if ((!bl || n7 - 8 < n13 && n7 != n13) && mp4BoxHeader.getFilePos() > mp4BoxHeader2.getFilePos()) {
                        logger.config("Adjusting Offsets");
                        mp4StcoBox.adjustOffsets(n13);
                    }
                    mp4BoxHeader2.setLength(mp4BoxHeader2.getLength() - n12 + n13);
                    fileChannel2.write(mp4BoxHeader2.getHeaderData());
                    byteBuffer2.rewind();
                    byteBuffer2.limit(n - n12);
                    fileChannel2.write(byteBuffer2);
                    fileChannel2.write(mp4BoxHeader4.getHeaderData());
                    fileChannel2.write(mp4MetaBox.getHeader().getHeaderData());
                    fileChannel2.write(mp4MetaBox.getData());
                    fileChannel2.write(mp4HdlrBox.getHeader().getHeaderData());
                    fileChannel2.write(mp4HdlrBox.getData());
                } else {
                    logger.config("Writing:Option 5.3;udta atom exists");
                    if ((!bl || n7 - 8 < n9 && n7 != n9) && mp4BoxHeader.getFilePos() > mp4BoxHeader2.getFilePos()) {
                        mp4StcoBox.adjustOffsets(n9);
                    }
                    this.adjustSizeOfMoovHeader(mp4BoxHeader2, byteBuffer2, n9, mp4BoxHeader4, mp4BoxHeader5);
                    fileChannel2.write(mp4BoxHeader2.getHeaderData());
                    byteBuffer2.rewind();
                    byteBuffer2.limit(n);
                    fileChannel2.write(byteBuffer2);
                }
                fileChannel2.write(byteBuffer);
                fileChannel.position(n2 + n3);
                fileChannel.position(fileChannel.position() + (long)n5);
                if (mp4BoxHeader7 != null) {
                    l3 = mp4BoxHeader7.getFilePos() - fileChannel.position();
                    fileChannel2.transferFrom(fileChannel, fileChannel2.position(), l3);
                    fileChannel2.position(fileChannel2.position() + l3);
                    this.convertandWriteTagsAtomToFreeAtom(fileChannel2, mp4BoxHeader7);
                    fileChannel.position(mp4BoxHeader7.getFilePos() + (long)mp4BoxHeader7.getLength());
                    long l4 = l - fileChannel.position();
                    fileChannel2.transferFrom(fileChannel, fileChannel2.position(), l4);
                } else {
                    l3 = l - fileChannel.position();
                    fileChannel2.transferFrom(fileChannel, fileChannel2.position(), l3);
                    fileChannel2.position(fileChannel2.position() + l3);
                }
                if (bl && n6 >= n2) {
                    void var33_42;
                    if (n7 - 8 >= var33_42) {
                        logger.config("Writing:Option 6;Larger Size can use top free atom");
                        Mp4FreeBox mp4FreeBox = new Mp4FreeBox(n7 - 8 - var33_42);
                        fileChannel2.write(mp4FreeBox.getHeader().getHeaderData());
                        fileChannel2.write(mp4FreeBox.getData());
                        fileChannel.position(fileChannel.position() + (long)n7);
                        this.writeDataInChunks(fileChannel, fileChannel2);
                    } else if (n7 == var33_42) {
                        logger.config("Writing:Option 7;Larger Size uses top free atom including header");
                        fileChannel.position(fileChannel.position() + (long)n7);
                        this.writeDataInChunks(fileChannel, fileChannel2);
                    } else {
                        logger.config("Writing:Option 8;Larger Size cannot use top free atom");
                        fileChannel2.transferFrom(fileChannel, fileChannel2.position(), fileChannel.size() - fileChannel.position());
                        this.writeDataInChunks(fileChannel, fileChannel2);
                    }
                } else {
                    logger.config("Writing:Option 9;Top Level Free comes after Mdat or before Metadata so cant use it");
                    this.writeDataInChunks(fileChannel, fileChannel2);
                }
            }
        }
        fileChannel.close();
        randomAccessFile.close();
        this.checkFileWrittenCorrectly(randomAccessFile2, mp4BoxHeader, fileChannel2, mp4StcoBox);
    }

    private void writeDataInChunks(FileChannel fileChannel, FileChannel fileChannel2) throws IOException, CannotWriteException {
        long l = fileChannel.size() - fileChannel.position();
        long l2 = 0L;
        long l3 = TagOptionSingleton.getInstance().getWriteChunkSize();
        long l4 = l / l3;
        long l5 = l % l3;
        int n = 0;
        while ((long)n < l4) {
            l2 += fileChannel2.transferFrom(fileChannel, fileChannel2.position(), l3);
            fileChannel2.position(fileChannel2.position() + l3);
            ++n;
        }
        if ((l2 += fileChannel2.transferFrom(fileChannel, fileChannel2.position(), l5)) != l) {
            throw new CannotWriteException("Was meant to write " + l + " bytes but only written " + l2 + " bytes");
        }
    }

    private void convertandWriteTagsAtomToFreeAtom(FileChannel fileChannel, Mp4BoxHeader mp4BoxHeader) throws IOException {
        Mp4FreeBox mp4FreeBox = new Mp4FreeBox(mp4BoxHeader.getDataLength());
        fileChannel.write(mp4FreeBox.getHeader().getHeaderData());
        fileChannel.write(mp4FreeBox.getData());
    }

    private void writeDataUptoIncludingIlst(FileChannel fileChannel, FileChannel fileChannel2, int n, int n2, ByteBuffer byteBuffer) throws IOException {
        fileChannel.position(0L);
        fileChannel2.transferFrom(fileChannel, 0L, n2);
        fileChannel2.position(n2);
        fileChannel2.write(byteBuffer);
        fileChannel.position(n2 + n);
    }

    private void writeDataAfterIlst(FileChannel fileChannel, FileChannel fileChannel2, Mp4BoxHeader mp4BoxHeader) throws IOException, CannotWriteException {
        if (mp4BoxHeader != null) {
            this.writeNeroData(fileChannel, fileChannel2, mp4BoxHeader);
        } else {
            this.writeDataInChunks(fileChannel, fileChannel2);
        }
    }

    private int getMetaLevelFreeAtomSize(Mp4AtomTree mp4AtomTree) {
        int n = 0;
        for (DefaultMutableTreeNode defaultMutableTreeNode : mp4AtomTree.getFreeNodes()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode.getPreviousSibling();
            if (defaultMutableTreeNode2.isRoot()) continue;
            Mp4BoxHeader mp4BoxHeader = (Mp4BoxHeader)defaultMutableTreeNode2.getUserObject();
            Mp4BoxHeader mp4BoxHeader2 = (Mp4BoxHeader)defaultMutableTreeNode.getUserObject();
            if (defaultMutableTreeNode3 == null) continue;
            Mp4BoxHeader mp4BoxHeader3 = (Mp4BoxHeader)defaultMutableTreeNode3.getUserObject();
            if (!mp4BoxHeader.getId().equals(Mp4AtomIdentifier.META.getFieldName()) || !mp4BoxHeader3.getId().equals(Mp4AtomIdentifier.ILST.getFieldName())) continue;
            n = mp4BoxHeader2.getLength();
            break;
        }
        return n;
    }

    private void checkFileWrittenCorrectly(RandomAccessFile randomAccessFile, Mp4BoxHeader mp4BoxHeader, FileChannel fileChannel, Mp4StcoBox mp4StcoBox) throws CannotWriteException, IOException {
        logger.config("Checking file has been written correctly");
        try {
            Mp4AtomTree mp4AtomTree = new Mp4AtomTree(randomAccessFile, false);
            Mp4BoxHeader mp4BoxHeader2 = mp4AtomTree.getBoxHeader(mp4AtomTree.getMdatNode());
            if (mp4BoxHeader2 == null) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_DATA.getMsg());
            }
            if (mp4BoxHeader2.getLength() != mp4BoxHeader.getLength()) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_DATA_CORRUPT.getMsg());
            }
            Mp4BoxHeader mp4BoxHeader3 = mp4AtomTree.getBoxHeader(mp4AtomTree.getUdtaNode());
            if (mp4BoxHeader3 == null) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_TAG_DATA.getMsg());
            }
            Mp4BoxHeader mp4BoxHeader4 = mp4AtomTree.getBoxHeader(mp4AtomTree.getMetaNode());
            if (mp4BoxHeader4 == null) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_TAG_DATA.getMsg());
            }
            Mp4StcoBox mp4StcoBox2 = mp4AtomTree.getStco();
            logger.finer("stco:Original First Offset" + mp4StcoBox.getFirstOffSet());
            logger.finer("stco:Original Diff" + (int)((long)mp4StcoBox.getFirstOffSet() - mp4BoxHeader.getFilePos()));
            logger.finer("stco:Original Mdat Pos" + mp4BoxHeader.getFilePos());
            logger.finer("stco:New First Offset" + mp4StcoBox2.getFirstOffSet());
            logger.finer("stco:New Diff" + (int)((long)mp4StcoBox2.getFirstOffSet() - mp4BoxHeader2.getFilePos()));
            logger.finer("stco:New Mdat Pos" + mp4BoxHeader2.getFilePos());
            int n = (int)((long)mp4StcoBox.getFirstOffSet() - mp4BoxHeader.getFilePos());
            if ((long)mp4StcoBox2.getFirstOffSet() - mp4BoxHeader2.getFilePos() != (long)n) {
                int n2 = (int)((long)mp4StcoBox2.getFirstOffSet() - mp4BoxHeader2.getFilePos() - (long)n);
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_INCORRECT_OFFSETS.getMsg(n2));
            }
        }
        catch (Exception exception) {
            if (exception instanceof CannotWriteException) {
                throw (CannotWriteException)exception;
            }
            exception.printStackTrace();
            throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED.getMsg() + ":" + exception.getMessage());
        }
        finally {
            randomAccessFile.close();
            fileChannel.close();
        }
        logger.config("File has been written correctly");
    }

    public void delete(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException {
        Mp4Tag mp4Tag = new Mp4Tag();
        try {
            this.write(mp4Tag, randomAccessFile, randomAccessFile2);
        }
        catch (CannotWriteException cannotWriteException) {
            throw new IOException(cannotWriteException.getMessage());
        }
    }
}

