/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4MetaBox;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.Mp4NonStandardFieldKey;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.mp4.field.Mp4DiscNoField;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;
import org.jaudiotagger.tag.mp4.field.Mp4GenreField;
import org.jaudiotagger.tag.mp4.field.Mp4TagBinaryField;
import org.jaudiotagger.tag.mp4.field.Mp4TagByteField;
import org.jaudiotagger.tag.mp4.field.Mp4TagCoverField;
import org.jaudiotagger.tag.mp4.field.Mp4TagRawBinaryField;
import org.jaudiotagger.tag.mp4.field.Mp4TagReverseDnsField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextNumberField;
import org.jaudiotagger.tag.mp4.field.Mp4TrackField;

public class Mp4TagReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.mp4");

    public Mp4Tag read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        Mp4MetaBox mp4MetaBox;
        Mp4Tag mp4Tag = new Mp4Tag();
        Mp4BoxHeader mp4BoxHeader = Mp4BoxHeader.seekWithinLevel(randomAccessFile, Mp4AtomIdentifier.MOOV.getFieldName());
        if (mp4BoxHeader == null) {
            throw new CannotReadException(ErrorMessage.MP4_FILE_NOT_CONTAINER.getMsg());
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(mp4BoxHeader.getLength() - 8);
        randomAccessFile.getChannel().read(byteBuffer);
        byteBuffer.rewind();
        Mp4BoxHeader mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer, Mp4AtomIdentifier.UDTA.getFieldName());
        if (mp4BoxHeader2 != null) {
            mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer, Mp4AtomIdentifier.META.getFieldName());
            if (mp4BoxHeader2 == null) {
                logger.warning(ErrorMessage.MP4_FILE_HAS_NO_METADATA.getMsg());
                return mp4Tag;
            }
            mp4MetaBox = new Mp4MetaBox(mp4BoxHeader2, byteBuffer);
            mp4MetaBox.processData();
            mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer, Mp4AtomIdentifier.ILST.getFieldName());
            if (mp4BoxHeader2 == null) {
                logger.warning(ErrorMessage.MP4_FILE_HAS_NO_METADATA.getMsg());
                return mp4Tag;
            }
        } else {
            mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer, Mp4AtomIdentifier.META.getFieldName());
            if (mp4BoxHeader2 == null) {
                logger.warning(ErrorMessage.MP4_FILE_HAS_NO_METADATA.getMsg());
                return mp4Tag;
            }
            mp4MetaBox = new Mp4MetaBox(mp4BoxHeader2, byteBuffer);
            mp4MetaBox.processData();
            mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer, Mp4AtomIdentifier.ILST.getFieldName());
            if (mp4BoxHeader2 == null) {
                logger.warning(ErrorMessage.MP4_FILE_HAS_NO_METADATA.getMsg());
                return mp4Tag;
            }
        }
        int n = mp4BoxHeader2.getLength() - 8;
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        logger.config("headerlengthsays:" + n + "datalength:" + byteBuffer2.limit());
        logger.config("Started to read metadata fields at position is in metadata buffer:" + byteBuffer2.position());
        for (int i = 0; i < n; i += mp4BoxHeader2.getLength()) {
            mp4BoxHeader2.update(byteBuffer2);
            logger.config("Next position is at:" + byteBuffer2.position());
            this.createMp4Field(mp4Tag, mp4BoxHeader2, byteBuffer2.slice());
            byteBuffer2.position(byteBuffer2.position() + mp4BoxHeader2.getDataLength());
        }
        return mp4Tag;
    }

    /*
     * WARNING - void declaration
     */
    private void createMp4Field(Mp4Tag mp4Tag, Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        if (mp4BoxHeader.getId().equals("----")) {
            try {
                Mp4TagReverseDnsField mp4TagReverseDnsField = new Mp4TagReverseDnsField(mp4BoxHeader, byteBuffer);
                mp4Tag.addField(mp4TagReverseDnsField);
            }
            catch (Exception exception) {
                logger.warning(ErrorMessage.MP4_UNABLE_READ_REVERSE_DNS_FIELD.getMsg(exception.getMessage()));
                Mp4TagRawBinaryField mp4TagRawBinaryField = new Mp4TagRawBinaryField(mp4BoxHeader, byteBuffer);
                mp4Tag.addField(mp4TagRawBinaryField);
            }
        } else {
            int n = byteBuffer.position();
            boolean bl = Utils.getString(byteBuffer, 4, 4, "ISO-8859-1").equals("data");
            byteBuffer.position(n);
            if (bl) {
                int n2 = Utils.getIntBE(byteBuffer, 9, 11);
                Mp4FieldType mp4FieldType = Mp4FieldType.getFieldType(n2);
                logger.config("Box Type id:" + mp4BoxHeader.getId() + ":type:" + (Object)((Object)mp4FieldType));
                if (mp4BoxHeader.getId().equals(Mp4FieldKey.TRACK.getFieldName())) {
                    Mp4TrackField mp4TrackField = new Mp4TrackField(mp4BoxHeader.getId(), byteBuffer);
                    mp4Tag.addField(mp4TrackField);
                } else if (mp4BoxHeader.getId().equals(Mp4FieldKey.DISCNUMBER.getFieldName())) {
                    Mp4DiscNoField mp4DiscNoField = new Mp4DiscNoField(mp4BoxHeader.getId(), byteBuffer);
                    mp4Tag.addField(mp4DiscNoField);
                } else if (mp4BoxHeader.getId().equals(Mp4FieldKey.GENRE.getFieldName())) {
                    Mp4GenreField mp4GenreField = new Mp4GenreField(mp4BoxHeader.getId(), byteBuffer);
                    mp4Tag.addField(mp4GenreField);
                } else if (mp4BoxHeader.getId().equals(Mp4FieldKey.ARTWORK.getFieldName()) || Mp4FieldType.isCoverArtType(mp4FieldType)) {
                    int n3 = 0;
                    boolean n4 = false;
                    while (n3 < mp4BoxHeader.getDataLength()) {
                        void object;
                        if (object > 0) {
                            n2 = Utils.getIntBE(byteBuffer, n3 + 9, n3 + 9 + 3 - 1);
                            mp4FieldType = Mp4FieldType.getFieldType(n2);
                        }
                        Mp4TagCoverField mp4TagCoverField = new Mp4TagCoverField(byteBuffer, mp4FieldType);
                        mp4Tag.addField(mp4TagCoverField);
                        n3 += mp4TagCoverField.getDataAndHeaderSize();
                        ++object;
                    }
                } else if (mp4FieldType == Mp4FieldType.TEXT) {
                    Mp4TagTextField mp4TagTextField = new Mp4TagTextField(mp4BoxHeader.getId(), byteBuffer);
                    mp4Tag.addField(mp4TagTextField);
                } else if (mp4FieldType == Mp4FieldType.IMPLICIT) {
                    Mp4TagTextNumberField mp4TagTextNumberField = new Mp4TagTextNumberField(mp4BoxHeader.getId(), byteBuffer);
                    mp4Tag.addField(mp4TagTextNumberField);
                } else if (mp4FieldType == Mp4FieldType.INTEGER) {
                    Mp4TagByteField mp4TagByteField = new Mp4TagByteField(mp4BoxHeader.getId(), byteBuffer);
                    mp4Tag.addField(mp4TagByteField);
                } else {
                    boolean bl2 = false;
                    for (Mp4FieldKey mp4FieldKey : Mp4FieldKey.values()) {
                        if (!mp4FieldKey.getFieldName().equals(mp4BoxHeader.getId())) continue;
                        bl2 = true;
                        logger.warning("Known Field:" + mp4BoxHeader.getId() + " with invalid field type of:" + n2 + " is ignored");
                        break;
                    }
                    if (!bl2) {
                        logger.warning("UnKnown Field:" + mp4BoxHeader.getId() + " with invalid field type of:" + n2 + " created as binary");
                        Mp4TagBinaryField mp4TagBinaryField = new Mp4TagBinaryField(mp4BoxHeader.getId(), byteBuffer);
                        mp4Tag.addField(mp4TagBinaryField);
                    }
                }
            } else if (mp4BoxHeader.getId().equals(Mp4NonStandardFieldKey.AAPR.getFieldName())) {
                Mp4TagRawBinaryField mp4TagRawBinaryField = new Mp4TagRawBinaryField(mp4BoxHeader, byteBuffer);
                mp4Tag.addField(mp4TagRawBinaryField);
            } else {
                Mp4TagRawBinaryField mp4TagRawBinaryField = new Mp4TagRawBinaryField(mp4BoxHeader, byteBuffer);
                mp4Tag.addField(mp4TagRawBinaryField);
            }
        }
    }
}

