/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotReadVideoException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.mp4.EncoderType;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.Mp4AtomTree;
import org.jaudiotagger.audio.mp4.Mp4AudioHeader;
import org.jaudiotagger.audio.mp4.atom.AbstractMp4Box;
import org.jaudiotagger.audio.mp4.atom.Mp4AlacBox;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4DrmsBox;
import org.jaudiotagger.audio.mp4.atom.Mp4EsdsBox;
import org.jaudiotagger.audio.mp4.atom.Mp4FtypBox;
import org.jaudiotagger.audio.mp4.atom.Mp4MdhdBox;
import org.jaudiotagger.audio.mp4.atom.Mp4Mp4aBox;
import org.jaudiotagger.audio.mp4.atom.Mp4MvhdBox;
import org.jaudiotagger.audio.mp4.atom.Mp4StsdBox;
import org.jaudiotagger.logging.ErrorMessage;

public class Mp4InfoReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.mp4.atom");

    private boolean isTrackAtomVideo(Mp4FtypBox mp4FtypBox, Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer) throws IOException {
        mp4BoxHeader = Mp4BoxHeader.seekWithinLevel(byteBuffer, Mp4AtomIdentifier.MDIA.getFieldName());
        if (mp4BoxHeader == null) {
            return false;
        }
        mp4BoxHeader = Mp4BoxHeader.seekWithinLevel(byteBuffer, Mp4AtomIdentifier.MDHD.getFieldName());
        if (mp4BoxHeader == null) {
            return false;
        }
        byteBuffer.position(byteBuffer.position() + mp4BoxHeader.getDataLength());
        mp4BoxHeader = Mp4BoxHeader.seekWithinLevel(byteBuffer, Mp4AtomIdentifier.MINF.getFieldName());
        if (mp4BoxHeader == null) {
            return false;
        }
        mp4BoxHeader = Mp4BoxHeader.seekWithinLevel(byteBuffer, Mp4AtomIdentifier.VMHD.getFieldName());
        return mp4BoxHeader != null;
    }

    public GenericAudioHeader read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        Mp4AudioHeader mp4AudioHeader = new Mp4AudioHeader();
        Mp4BoxHeader mp4BoxHeader = Mp4BoxHeader.seekWithinLevel(randomAccessFile, Mp4AtomIdentifier.FTYP.getFieldName());
        if (mp4BoxHeader == null) {
            throw new CannotReadException(ErrorMessage.MP4_FILE_NOT_CONTAINER.getMsg());
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(mp4BoxHeader.getLength() - 8);
        randomAccessFile.getChannel().read(byteBuffer);
        byteBuffer.rewind();
        Mp4FtypBox mp4FtypBox = new Mp4FtypBox(mp4BoxHeader, byteBuffer);
        mp4FtypBox.processData();
        mp4AudioHeader.setBrand(mp4FtypBox.getMajorBrand());
        Mp4BoxHeader mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(randomAccessFile, Mp4AtomIdentifier.MOOV.getFieldName());
        if (mp4BoxHeader2 == null) {
            throw new CannotReadException(ErrorMessage.MP4_FILE_NOT_AUDIO.getMsg());
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(mp4BoxHeader2.getLength() - 8);
        randomAccessFile.getChannel().read(byteBuffer2);
        byteBuffer2.rewind();
        Mp4BoxHeader mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer2, Mp4AtomIdentifier.MVHD.getFieldName());
        if (mp4BoxHeader3 == null) {
            throw new CannotReadException(ErrorMessage.MP4_FILE_NOT_AUDIO.getMsg());
        }
        ByteBuffer byteBuffer3 = byteBuffer2.slice();
        Mp4MvhdBox mp4MvhdBox = new Mp4MvhdBox(mp4BoxHeader3, byteBuffer3);
        mp4AudioHeader.setLength(mp4MvhdBox.getLength());
        byteBuffer3.position(byteBuffer3.position() + mp4BoxHeader3.getDataLength());
        mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.TRAK.getFieldName());
        int n = byteBuffer3.position() + mp4BoxHeader3.getDataLength();
        if (mp4BoxHeader3 == null) {
            throw new CannotReadException(ErrorMessage.MP4_FILE_NOT_AUDIO.getMsg());
        }
        mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.MDIA.getFieldName());
        if (mp4BoxHeader3 == null) {
            throw new CannotReadException(ErrorMessage.MP4_FILE_NOT_AUDIO.getMsg());
        }
        mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.MDHD.getFieldName());
        if (mp4BoxHeader3 == null) {
            throw new CannotReadException(ErrorMessage.MP4_FILE_NOT_AUDIO.getMsg());
        }
        Mp4MdhdBox mp4MdhdBox = new Mp4MdhdBox(mp4BoxHeader3, byteBuffer3.slice());
        mp4AudioHeader.setSamplingRate(mp4MdhdBox.getSampleRate());
        byteBuffer3.position(byteBuffer3.position() + mp4BoxHeader3.getDataLength());
        mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.MINF.getFieldName());
        if (mp4BoxHeader3 == null) {
            throw new CannotReadException(ErrorMessage.MP4_FILE_NOT_AUDIO.getMsg());
        }
        int n2 = byteBuffer3.position();
        mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.SMHD.getFieldName());
        if (mp4BoxHeader3 == null) {
            byteBuffer3.position(n2);
            mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.VMHD.getFieldName());
            if (mp4BoxHeader3 != null) {
                throw new CannotReadVideoException(ErrorMessage.MP4_FILE_IS_VIDEO.getMsg());
            }
            throw new CannotReadException(ErrorMessage.MP4_FILE_NOT_AUDIO.getMsg());
        }
        byteBuffer3.position(byteBuffer3.position() + mp4BoxHeader3.getDataLength());
        mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.STBL.getFieldName());
        if (mp4BoxHeader3 == null) {
            throw new CannotReadException(ErrorMessage.MP4_FILE_NOT_AUDIO.getMsg());
        }
        mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.STSD.getFieldName());
        if (mp4BoxHeader3 != null) {
            AbstractMp4Box abstractMp4Box;
            Object object;
            Mp4StsdBox mp4StsdBox = new Mp4StsdBox(mp4BoxHeader3, byteBuffer3);
            mp4StsdBox.processData();
            int n3 = byteBuffer3.position();
            mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.MP4A.getFieldName());
            if (mp4BoxHeader3 != null) {
                object = byteBuffer3.slice();
                abstractMp4Box = new Mp4Mp4aBox(mp4BoxHeader3, (ByteBuffer)object);
                ((Mp4Mp4aBox)abstractMp4Box).processData();
                mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel((ByteBuffer)object, Mp4AtomIdentifier.ESDS.getFieldName());
                if (mp4BoxHeader3 != null) {
                    Mp4EsdsBox mp4EsdsBox = new Mp4EsdsBox(mp4BoxHeader3, ((ByteBuffer)object).slice());
                    mp4AudioHeader.setBitrate(mp4EsdsBox.getAvgBitrate() / 1000);
                    mp4AudioHeader.setChannelNumber(mp4EsdsBox.getNumberOfChannels());
                    mp4AudioHeader.setKind(mp4EsdsBox.getKind());
                    mp4AudioHeader.setProfile(mp4EsdsBox.getAudioProfile());
                    mp4AudioHeader.setEncodingType(EncoderType.AAC.getDescription());
                }
            } else {
                byteBuffer3.position(n3);
                mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.DRMS.getFieldName());
                if (mp4BoxHeader3 != null) {
                    object = new Mp4DrmsBox(mp4BoxHeader3, byteBuffer3);
                    ((Mp4DrmsBox)object).processData();
                    mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.ESDS.getFieldName());
                    if (mp4BoxHeader3 != null) {
                        abstractMp4Box = new Mp4EsdsBox(mp4BoxHeader3, byteBuffer3.slice());
                        mp4AudioHeader.setBitrate(((Mp4EsdsBox)abstractMp4Box).getAvgBitrate() / 1000);
                        mp4AudioHeader.setChannelNumber(((Mp4EsdsBox)abstractMp4Box).getNumberOfChannels());
                        mp4AudioHeader.setKind(((Mp4EsdsBox)abstractMp4Box).getKind());
                        mp4AudioHeader.setProfile(((Mp4EsdsBox)abstractMp4Box).getAudioProfile());
                        mp4AudioHeader.setEncodingType(EncoderType.DRM_AAC.getDescription());
                    }
                } else {
                    byteBuffer3.position(n3);
                    mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.ALAC.getFieldName());
                    if (mp4BoxHeader3 != null) {
                        object = new Mp4AlacBox(mp4BoxHeader3, byteBuffer3);
                        ((Mp4AlacBox)object).processData();
                        mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.ALAC.getFieldName());
                        if (mp4BoxHeader3 != null) {
                            object = new Mp4AlacBox(mp4BoxHeader3, byteBuffer3);
                            ((Mp4AlacBox)object).processData();
                            mp4AudioHeader.setEncodingType(EncoderType.APPLE_LOSSLESS.getDescription());
                            mp4AudioHeader.setChannelNumber(((Mp4AlacBox)object).getChannels());
                            mp4AudioHeader.setBitrate(((Mp4AlacBox)object).getBitRate() / 1000);
                            mp4AudioHeader.setBitsPerSample(((Mp4AlacBox)object).getSampleSize());
                        }
                    }
                }
            }
        }
        if (mp4AudioHeader.getChannelNumber() == -1) {
            mp4AudioHeader.setChannelNumber(2);
        }
        if (mp4AudioHeader.getBitRateAsNumber() == -1L) {
            mp4AudioHeader.setBitrate(128);
        }
        if (mp4AudioHeader.getBitsPerSample() == -1) {
            mp4AudioHeader.setBitsPerSample(16);
        }
        if (mp4AudioHeader.getEncodingType().equals("")) {
            mp4AudioHeader.setEncodingType(EncoderType.AAC.getDescription());
        }
        logger.config(mp4AudioHeader.toString());
        byteBuffer3.position(n);
        while (byteBuffer3.hasRemaining() && (mp4BoxHeader3 = Mp4BoxHeader.seekWithinLevel(byteBuffer3, Mp4AtomIdentifier.TRAK.getFieldName())) != null) {
            if (!this.isTrackAtomVideo(mp4FtypBox, mp4BoxHeader3, byteBuffer3)) continue;
            throw new CannotReadVideoException(ErrorMessage.MP4_FILE_IS_VIDEO.getMsg());
        }
        new Mp4AtomTree(randomAccessFile, false);
        return mp4AudioHeader;
    }
}

