/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.logging.AbstractTagDisplayFormatter;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.logging.Hex;
import org.jaudiotagger.logging.PlainTextTagDisplayFormatter;
import org.jaudiotagger.logging.XMLTagDisplayFormatter;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v22Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3;
import org.jaudiotagger.tag.reference.ID3V2Version;
import sun.nio.ch.DirectBuffer;

public class MP3File
extends AudioFile {
    private static final int MINIMUM_FILESIZE = 150;
    protected static AbstractTagDisplayFormatter tagFormatter;
    private AbstractID3v2Tag id3v2tag = null;
    private ID3v24Tag id3v2Asv24tag = null;
    private AbstractLyrics3 lyrics3tag = null;
    private ID3v1Tag id3v1tag = null;
    public static final int LOAD_IDV1TAG = 2;
    public static final int LOAD_IDV2TAG = 4;
    public static final int LOAD_LYRICS3 = 8;
    public static final int LOAD_ALL = 14;

    public MP3File() {
    }

    public MP3File(String string) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(new File(string));
    }

    public MP3File(File file, int n) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(file, n, false);
    }

    private void readV1Tag(File file, RandomAccessFile randomAccessFile, int n) throws IOException {
        if ((n & 2) != 0) {
            logger.finer("Attempting to read id3v1tags");
            try {
                this.id3v1tag = new ID3v11Tag(randomAccessFile, file.getName());
            }
            catch (TagNotFoundException tagNotFoundException) {
                logger.config("No ids3v11 tag found");
            }
            try {
                if (this.id3v1tag == null) {
                    this.id3v1tag = new ID3v1Tag(randomAccessFile, file.getName());
                }
            }
            catch (TagNotFoundException tagNotFoundException) {
                logger.config("No id3v1 tag found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readV2Tag(File file, int n, int n2) throws IOException, TagException {
        if (n2 >= 10) {
            ByteBuffer byteBuffer;
            logger.finer("Attempting to read id3v2tags");
            FileInputStream fileInputStream = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            try {
                fileInputStream = new FileInputStream(file);
                abstractInterruptibleChannel = fileInputStream.getChannel();
                byteBuffer = ((FileChannel)abstractInterruptibleChannel).map(FileChannel.MapMode.READ_ONLY, 0L, n2);
            }
            catch (IOException iOException) {
                byteBuffer = ByteBuffer.allocate(n2);
                ((FileChannel)abstractInterruptibleChannel).read(byteBuffer, 0L);
            }
            finally {
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            try {
                byteBuffer.rewind();
                if ((n & 4) == 0) return;
                logger.config("Attempting to read id3v2tags");
                try {
                    this.setID3v2Tag(new ID3v24Tag(byteBuffer, file.getName()));
                }
                catch (TagNotFoundException tagNotFoundException) {
                    logger.config("No id3v24 tag found");
                }
                try {
                    if (this.id3v2tag == null) {
                        this.setID3v2Tag(new ID3v23Tag(byteBuffer, file.getName()));
                    }
                }
                catch (TagNotFoundException tagNotFoundException) {
                    logger.config("No id3v23 tag found");
                }
                try {
                    if (this.id3v2tag != null) return;
                    this.setID3v2Tag(new ID3v22Tag(byteBuffer, file.getName()));
                    return;
                }
                catch (TagNotFoundException tagNotFoundException) {
                    logger.config("No id3v22 tag found");
                }
                return;
            }
            finally {
                byteBuffer.clear();
                if (byteBuffer != null && byteBuffer.isDirect()) {
                    ((DirectBuffer)((Object)byteBuffer)).cleaner().clean();
                }
            }
        }
        logger.config("Not enough room for valid id3v2 tag:" + n2);
    }

    private void readLyrics3Tag(File file, RandomAccessFile randomAccessFile, int n) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFilePortionNull(int n, int n2) throws IOException {
        logger.config("Checking file portion:" + Hex.asHex(n) + ":" + Hex.asHex(n2));
        FileInputStream fileInputStream = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileInputStream = new FileInputStream(this.file);
            abstractInterruptibleChannel = fileInputStream.getChannel();
            ((FileChannel)abstractInterruptibleChannel).position(n);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 - n);
            ((FileChannel)abstractInterruptibleChannel).read(byteBuffer);
            while (byteBuffer.hasRemaining()) {
                if (byteBuffer.get() == 0) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return true;
    }

    private MP3AudioHeader checkAudioStart(long l, MP3AudioHeader mP3AudioHeader) throws IOException, InvalidAudioFrameException {
        logger.warning(ErrorMessage.MP3_ID3TAG_LENGTH_INCORRECT.getMsg(this.file.getPath(), Hex.asHex(l), Hex.asHex(mP3AudioHeader.getMp3StartByte())));
        MP3AudioHeader mP3AudioHeader2 = new MP3AudioHeader(this.file, 0L);
        logger.config("Checking from start:" + mP3AudioHeader2);
        if (mP3AudioHeader.getMp3StartByte() == mP3AudioHeader2.getMp3StartByte()) {
            logger.config(ErrorMessage.MP3_START_OF_AUDIO_CONFIRMED.getMsg(this.file.getPath(), Hex.asHex(mP3AudioHeader2.getMp3StartByte())));
            return mP3AudioHeader;
        }
        logger.config(ErrorMessage.MP3_RECALCULATED_POSSIBLE_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(mP3AudioHeader2.getMp3StartByte())));
        if (mP3AudioHeader.getNumberOfFrames() == mP3AudioHeader2.getNumberOfFrames()) {
            logger.warning(ErrorMessage.MP3_RECALCULATED_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(mP3AudioHeader2.getMp3StartByte())));
            return mP3AudioHeader2;
        }
        if (this.isFilePortionNull((int)l, (int)mP3AudioHeader.getMp3StartByte())) {
            return mP3AudioHeader;
        }
        MP3AudioHeader mP3AudioHeader3 = new MP3AudioHeader(this.file, mP3AudioHeader2.getMp3StartByte() + (long)mP3AudioHeader2.mp3FrameHeader.getFrameLength());
        if (mP3AudioHeader3.getMp3StartByte() == mP3AudioHeader.getMp3StartByte()) {
            logger.warning(ErrorMessage.MP3_START_OF_AUDIO_CONFIRMED.getMsg(this.file.getPath(), Hex.asHex(mP3AudioHeader.getMp3StartByte())));
            return mP3AudioHeader;
        }
        if (mP3AudioHeader3.getNumberOfFrames() == mP3AudioHeader2.getNumberOfFrames()) {
            logger.warning(ErrorMessage.MP3_RECALCULATED_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(mP3AudioHeader2.getMp3StartByte())));
            return mP3AudioHeader2;
        }
        logger.warning(ErrorMessage.MP3_RECALCULATED_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(mP3AudioHeader.getMp3StartByte())));
        return mP3AudioHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MP3File(File file, int n, boolean bl) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        try (RandomAccessFile randomAccessFile = null;){
            this.file = file;
            randomAccessFile = this.checkFilePermissions(file, bl);
            long l = AbstractID3v2Tag.getV2TagSizeIfExists(file);
            logger.config("TagHeaderSize:" + Hex.asHex(l));
            this.audioHeader = new MP3AudioHeader(file, l);
            if (l != ((MP3AudioHeader)this.audioHeader).getMp3StartByte()) {
                logger.config("First header found after tag:" + this.audioHeader);
                this.audioHeader = this.checkAudioStart(l, (MP3AudioHeader)this.audioHeader);
            }
            this.readV1Tag(file, randomAccessFile, n);
            this.readV2Tag(file, n, (int)((MP3AudioHeader)this.audioHeader).getMp3StartByte());
            if (this.getID3v2Tag() != null) {
                this.tag = this.getID3v2Tag();
            } else if (this.id3v1tag != null) {
                this.tag = this.id3v1tag;
            }
        }
    }

    public long getMP3StartByte(File file) throws InvalidAudioFrameException, IOException {
        try {
            long l = AbstractID3v2Tag.getV2TagSizeIfExists(file);
            MP3AudioHeader mP3AudioHeader = new MP3AudioHeader(file, l);
            if (l != mP3AudioHeader.getMp3StartByte()) {
                logger.config("First header found after tag:" + mP3AudioHeader);
                mP3AudioHeader = this.checkAudioStart(l, mP3AudioHeader);
            }
            return mP3AudioHeader.getMp3StartByte();
        }
        catch (InvalidAudioFrameException invalidAudioFrameException) {
            throw invalidAudioFrameException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public File extractID3v2TagDataIntoFile(File file) throws TagNotFoundException, IOException {
        int n = (int)((MP3AudioHeader)this.audioHeader).getMp3StartByte();
        if (n >= 0) {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            fileChannel.read(byteBuffer);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byteBuffer.array());
            fileOutputStream.close();
            fileChannel.close();
            fileInputStream.close();
            return file;
        }
        throw new TagNotFoundException("There is no ID3v2Tag data in this file");
    }

    public MP3AudioHeader getMP3AudioHeader() {
        return (MP3AudioHeader)this.getAudioHeader();
    }

    public boolean hasID3v1Tag() {
        return this.id3v1tag != null;
    }

    public boolean hasID3v2Tag() {
        return this.id3v2tag != null;
    }

    public MP3File(File file) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(file, 14);
    }

    public void setID3v1Tag(ID3v1Tag iD3v1Tag) {
        logger.config("setting tagv1:v1 tag");
        this.id3v1tag = iD3v1Tag;
    }

    public void setID3v1Tag(Tag tag) {
        logger.config("setting tagv1:v1 tag");
        this.id3v1tag = (ID3v1Tag)tag;
    }

    public void setID3v1Tag(AbstractTag abstractTag) {
        logger.config("setting tagv1:abstract");
        this.id3v1tag = new ID3v11Tag(abstractTag);
    }

    public ID3v1Tag getID3v1Tag() {
        return this.id3v1tag;
    }

    public void setID3v2Tag(AbstractTag abstractTag) {
        this.id3v2tag = new ID3v24Tag(abstractTag);
    }

    public void setID3v2Tag(AbstractID3v2Tag abstractID3v2Tag) {
        this.id3v2tag = abstractID3v2Tag;
        this.id3v2Asv24tag = abstractID3v2Tag instanceof ID3v24Tag ? (ID3v24Tag)this.id3v2tag : new ID3v24Tag((AbstractTag)abstractID3v2Tag);
    }

    public void setID3v2TagOnly(AbstractID3v2Tag abstractID3v2Tag) {
        this.id3v2tag = abstractID3v2Tag;
        this.id3v2Asv24tag = null;
    }

    public AbstractID3v2Tag getID3v2Tag() {
        return this.id3v2tag;
    }

    public ID3v24Tag getID3v2TagAsv24() {
        return this.id3v2Asv24tag;
    }

    public void delete(AbstractTag abstractTag) throws FileNotFoundException, IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rws");
        abstractTag.delete(randomAccessFile);
        randomAccessFile.close();
        if (abstractTag instanceof ID3v1Tag) {
            this.id3v1tag = null;
        }
        if (abstractTag instanceof AbstractID3v2Tag) {
            this.id3v2tag = null;
        }
    }

    public void save() throws IOException, TagException {
        this.save(this.file);
    }

    @Override
    public void commit() throws CannotWriteException {
        try {
            this.save();
        }
        catch (IOException iOException) {
            throw new CannotWriteException(iOException);
        }
        catch (TagException tagException) {
            throw new CannotWriteException(tagException);
        }
    }

    public void precheck(File file) throws IOException {
        if (!file.exists()) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_NOT_FOUND.getMsg(file.getName()));
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_NOT_FOUND.getMsg(file.getName()));
        }
        if (!file.canWrite()) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(file.getName()));
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(file.getName()));
        }
        if (file.length() <= 150L) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file.getName()));
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file.getName()));
        }
    }

    public void save(File file) throws IOException {
        File file2 = file.getAbsoluteFile();
        logger.config("Saving  : " + file2.getPath());
        this.precheck(file2);
        try (RandomAccessFile randomAccessFile = null;){
            if (TagOptionSingleton.getInstance().isId3v2Save()) {
                if (this.id3v2tag == null) {
                    randomAccessFile = new RandomAccessFile(file2, "rws");
                    new ID3v24Tag().delete(randomAccessFile);
                    new ID3v23Tag().delete(randomAccessFile);
                    new ID3v22Tag().delete(randomAccessFile);
                    logger.config("Deleting ID3v2 tag:" + file2.getName());
                    randomAccessFile.close();
                } else {
                    logger.config("Writing ID3v2 tag:" + file2.getName());
                    this.id3v2tag.write(file2, ((MP3AudioHeader)this.getAudioHeader()).getMp3StartByte());
                }
            }
            randomAccessFile = new RandomAccessFile(file2, "rws");
            if (TagOptionSingleton.getInstance().isLyrics3Save() && this.lyrics3tag != null) {
                this.lyrics3tag.write(randomAccessFile);
            }
            if (TagOptionSingleton.getInstance().isId3v1Save()) {
                logger.config("Processing ID3v1");
                if (this.id3v1tag == null) {
                    logger.config("Deleting ID3v1");
                    new ID3v1Tag().delete(randomAccessFile);
                } else {
                    logger.config("Saving ID3v1");
                    this.id3v1tag.write(randomAccessFile);
                }
            }
        }
    }

    @Override
    public String displayStructureAsXML() {
        MP3File.createXMLStructureFormatter();
        tagFormatter.openHeadingElement("file", this.getFile().getAbsolutePath());
        if (this.getID3v1Tag() != null) {
            this.getID3v1Tag().createStructure();
        }
        if (this.getID3v2Tag() != null) {
            this.getID3v2Tag().createStructure();
        }
        tagFormatter.closeHeadingElement("file");
        return tagFormatter.toString();
    }

    @Override
    public String displayStructureAsPlainText() {
        MP3File.createPlainTextStructureFormatter();
        tagFormatter.openHeadingElement("file", this.getFile().getAbsolutePath());
        if (this.getID3v1Tag() != null) {
            this.getID3v1Tag().createStructure();
        }
        if (this.getID3v2Tag() != null) {
            this.getID3v2Tag().createStructure();
        }
        tagFormatter.closeHeadingElement("file");
        return tagFormatter.toString();
    }

    private static void createXMLStructureFormatter() {
        tagFormatter = new XMLTagDisplayFormatter();
    }

    private static void createPlainTextStructureFormatter() {
        tagFormatter = new PlainTextTagDisplayFormatter();
    }

    public static AbstractTagDisplayFormatter getStructureFormatter() {
        return tagFormatter;
    }

    @Override
    public void setTag(Tag tag) {
        this.tag = tag;
        if (tag instanceof ID3v1Tag) {
            this.setID3v1Tag((ID3v1Tag)tag);
        } else {
            this.setID3v2Tag((AbstractID3v2Tag)tag);
        }
    }

    @Override
    public Tag createDefaultTag() {
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V24) {
            return new ID3v24Tag();
        }
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V23) {
            return new ID3v23Tag();
        }
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V22) {
            return new ID3v22Tag();
        }
        return new ID3v24Tag();
    }

    public Tag convertTag(Tag tag, ID3V2Version iD3V2Version) {
        if (tag instanceof ID3v24Tag) {
            switch (iD3V2Version) {
                case ID3_V22: {
                    return new ID3v22Tag((AbstractTag)((ID3v24Tag)tag));
                }
                case ID3_V23: {
                    return new ID3v23Tag((AbstractTag)((ID3v24Tag)tag));
                }
                case ID3_V24: {
                    return tag;
                }
            }
        } else if (tag instanceof ID3v23Tag) {
            switch (iD3V2Version) {
                case ID3_V22: {
                    return new ID3v22Tag((AbstractTag)((ID3v23Tag)tag));
                }
                case ID3_V23: {
                    return tag;
                }
                case ID3_V24: {
                    return new ID3v24Tag((AbstractTag)((ID3v23Tag)tag));
                }
            }
        } else if (tag instanceof ID3v22Tag) {
            switch (iD3V2Version) {
                case ID3_V22: {
                    return tag;
                }
                case ID3_V23: {
                    return new ID3v23Tag((AbstractTag)((ID3v22Tag)tag));
                }
                case ID3_V24: {
                    return new ID3v24Tag((AbstractTag)((ID3v22Tag)tag));
                }
            }
        }
        return tag;
    }

    @Override
    public Tag getTagOrCreateDefault() {
        AbstractID3v2Tag abstractID3v2Tag = this.getID3v2Tag();
        if (abstractID3v2Tag == null) {
            return this.createDefaultTag();
        }
        return abstractID3v2Tag;
    }

    @Override
    public Tag getTagAndConvertOrCreateAndSetDefault() {
        Tag tag = this.getTagOrCreateDefault();
        tag = this.convertTag(tag, TagOptionSingleton.getInstance().getID3V2Version());
        this.setTag(tag);
        return tag;
    }
}

