/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.ModifyVetoException;
import org.jaudiotagger.audio.generic.AudioFileModificationListener;

public class ModificationHandler
implements AudioFileModificationListener {
    private Vector<AudioFileModificationListener> listeners = new Vector();

    public void addAudioFileModificationListener(AudioFileModificationListener audioFileModificationListener) {
        if (!this.listeners.contains(audioFileModificationListener)) {
            this.listeners.add(audioFileModificationListener);
        }
    }

    @Override
    public void fileModified(AudioFile audioFile, File file) throws ModifyVetoException {
        Iterator<AudioFileModificationListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AudioFileModificationListener audioFileModificationListener;
            AudioFileModificationListener audioFileModificationListener2 = audioFileModificationListener = iterator.next();
            try {
                audioFileModificationListener2.fileModified(audioFile, file);
            }
            catch (ModifyVetoException modifyVetoException) {
                this.vetoThrown(audioFileModificationListener2, audioFile, modifyVetoException);
                throw modifyVetoException;
            }
        }
    }

    @Override
    public void fileOperationFinished(File file) {
        Iterator<AudioFileModificationListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AudioFileModificationListener audioFileModificationListener;
            AudioFileModificationListener audioFileModificationListener2 = audioFileModificationListener = iterator.next();
            audioFileModificationListener2.fileOperationFinished(file);
        }
    }

    @Override
    public void fileWillBeModified(AudioFile audioFile, boolean bl) throws ModifyVetoException {
        Iterator<AudioFileModificationListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AudioFileModificationListener audioFileModificationListener;
            AudioFileModificationListener audioFileModificationListener2 = audioFileModificationListener = iterator.next();
            try {
                audioFileModificationListener2.fileWillBeModified(audioFile, bl);
            }
            catch (ModifyVetoException modifyVetoException) {
                this.vetoThrown(audioFileModificationListener2, audioFile, modifyVetoException);
                throw modifyVetoException;
            }
        }
    }

    public void removeAudioFileModificationListener(AudioFileModificationListener audioFileModificationListener) {
        if (this.listeners.contains(audioFileModificationListener)) {
            this.listeners.remove(audioFileModificationListener);
        }
    }

    @Override
    public void vetoThrown(AudioFileModificationListener audioFileModificationListener, AudioFile audioFile, ModifyVetoException modifyVetoException) {
        Iterator<AudioFileModificationListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AudioFileModificationListener audioFileModificationListener2;
            AudioFileModificationListener audioFileModificationListener3 = audioFileModificationListener2 = iterator.next();
            audioFileModificationListener3.vetoThrown(audioFileModificationListener, audioFile, modifyVetoException);
        }
    }
}

