/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac.metadatablock;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockData;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.reference.PictureTypes;

public class MetadataBlockDataPicture
implements MetadataBlockData,
TagField {
    public static final String IMAGE_IS_URL = "-->";
    private int pictureType;
    private String mimeType;
    private String description;
    private int width;
    private int height;
    private int colourDepth;
    private int indexedColouredCount;
    private byte[] imageData;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac.MetadataBlockDataPicture");

    private void initFromByteBuffer(ByteBuffer byteBuffer) throws IOException, InvalidFrameException {
        this.pictureType = byteBuffer.getInt();
        if (this.pictureType >= PictureTypes.getInstanceOf().getSize()) {
            throw new InvalidFrameException("PictureType was:" + this.pictureType + "but the maximum allowed is " + (PictureTypes.getInstanceOf().getSize() - 1));
        }
        int n = byteBuffer.getInt();
        this.mimeType = this.getString(byteBuffer, n, "ISO-8859-1");
        int n2 = byteBuffer.getInt();
        this.description = this.getString(byteBuffer, n2, "UTF-8");
        this.width = byteBuffer.getInt();
        this.height = byteBuffer.getInt();
        this.colourDepth = byteBuffer.getInt();
        this.indexedColouredCount = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        this.imageData = new byte[n3];
        byteBuffer.get(this.imageData);
        logger.config("Read image:" + this.toString());
    }

    public MetadataBlockDataPicture(ByteBuffer byteBuffer) throws IOException, InvalidFrameException {
        this.initFromByteBuffer(byteBuffer);
    }

    public MetadataBlockDataPicture(MetadataBlockHeader metadataBlockHeader, RandomAccessFile randomAccessFile) throws IOException, InvalidFrameException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(metadataBlockHeader.getDataLength());
        int n = randomAccessFile.getChannel().read(byteBuffer);
        if (n < metadataBlockHeader.getDataLength()) {
            throw new IOException("Unable to read required number of databytes read:" + n + ":required:" + metadataBlockHeader.getDataLength());
        }
        byteBuffer.rewind();
        this.initFromByteBuffer(byteBuffer);
    }

    public MetadataBlockDataPicture(byte[] byArray, int n, String string, String string2, int n2, int n3, int n4, int n5) {
        this.pictureType = n;
        this.mimeType = string;
        this.description = string2;
        this.width = n2;
        this.height = n3;
        this.colourDepth = n4;
        this.indexedColouredCount = n5;
        this.imageData = byArray;
    }

    private String getString(ByteBuffer byteBuffer, int n, String string) throws IOException {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new String(byArray, string);
    }

    @Override
    public byte[] getBytes() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(Utils.getSizeBEInt32(this.pictureType));
            byteArrayOutputStream.write(Utils.getSizeBEInt32(this.mimeType.length()));
            byteArrayOutputStream.write(this.mimeType.getBytes("ISO-8859-1"));
            byteArrayOutputStream.write(Utils.getSizeBEInt32(this.description.length()));
            byteArrayOutputStream.write(this.description.getBytes("UTF-8"));
            byteArrayOutputStream.write(Utils.getSizeBEInt32(this.width));
            byteArrayOutputStream.write(Utils.getSizeBEInt32(this.height));
            byteArrayOutputStream.write(Utils.getSizeBEInt32(this.colourDepth));
            byteArrayOutputStream.write(Utils.getSizeBEInt32(this.indexedColouredCount));
            byteArrayOutputStream.write(Utils.getSizeBEInt32(this.imageData.length));
            byteArrayOutputStream.write(this.imageData);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    @Override
    public int getLength() {
        return this.getBytes().length;
    }

    public int getPictureType() {
        return this.pictureType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColourDepth() {
        return this.colourDepth;
    }

    public int getIndexedColourCount() {
        return this.indexedColouredCount;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public boolean isImageUrl() {
        return this.getMimeType().equals(IMAGE_IS_URL);
    }

    public String getImageUrl() {
        if (this.isImageUrl()) {
            return Utils.getString(this.getImageData(), 0, this.getImageData().length, "ISO-8859-1");
        }
        return "";
    }

    @Override
    public String toString() {
        return PictureTypes.getInstanceOf().getValueForId(this.pictureType) + ":" + this.mimeType + ":" + this.description + ":" + "width:" + this.width + ":height:" + this.height + ":colourdepth:" + this.colourDepth + ":indexedColourCount:" + this.indexedColouredCount + ":image size in bytes:" + this.imageData.length;
    }

    @Override
    public void copyContent(TagField tagField) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return FieldKey.COVER_ART.name();
    }

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        return this.getBytes();
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public void isBinary(boolean bl) {
    }

    @Override
    public boolean isCommon() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

