/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.flac.FlacStreamReader;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentReader;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class FlacTagReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    private VorbisCommentReader vorbisCommentReader = new VorbisCommentReader();

    public FlacTag read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        Object object;
        FlacStreamReader flacStreamReader = new FlacStreamReader(randomAccessFile);
        flacStreamReader.findStream();
        VorbisCommentTag vorbisCommentTag = null;
        ArrayList<MetadataBlockDataPicture> arrayList = new ArrayList<MetadataBlockDataPicture>();
        boolean bl = false;
        while (!bl) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("Looking for MetaBlockHeader at:" + randomAccessFile.getFilePointer());
            }
            if ((object = MetadataBlockHeader.readHeader(randomAccessFile)) == null) break;
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("Reading MetadataBlockHeader:" + ((MetadataBlockHeader)object).toString() + " ending at " + randomAccessFile.getFilePointer());
            }
            switch (((MetadataBlockHeader)object).getBlockType()) {
                case VORBIS_COMMENT: {
                    byte[] byArray = new byte[((MetadataBlockHeader)object).getDataLength()];
                    randomAccessFile.read(byArray);
                    vorbisCommentTag = this.vorbisCommentReader.read(byArray, false);
                    break;
                }
                case PICTURE: {
                    try {
                        MetadataBlockDataPicture metadataBlockDataPicture = new MetadataBlockDataPicture((MetadataBlockHeader)object, randomAccessFile);
                        arrayList.add(metadataBlockDataPicture);
                    }
                    catch (IOException iOException) {
                        logger.warning("Unable to read picture metablock, ignoring:" + iOException.getMessage());
                    }
                    catch (InvalidFrameException invalidFrameException) {
                        logger.warning("Unable to read picture metablock, ignoring" + invalidFrameException.getMessage());
                    }
                    break;
                }
                default: {
                    if (logger.isLoggable(Level.CONFIG)) {
                        logger.config("Ignoring MetadataBlock:" + (Object)((Object)((MetadataBlockHeader)object).getBlockType()));
                    }
                    randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)((MetadataBlockHeader)object).getDataLength());
                }
            }
            bl = ((MetadataBlockHeader)object).isLastBlock();
            object = null;
        }
        if (vorbisCommentTag == null) {
            vorbisCommentTag = VorbisCommentTag.createNewTag();
        }
        object = new FlacTag(vorbisCommentTag, arrayList);
        return object;
    }
}

