/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;

public class FlacStreamReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    public static final int FLAC_STREAM_IDENTIFIER_LENGTH = 4;
    public static final String FLAC_STREAM_IDENTIFIER = "fLaC";
    private RandomAccessFile raf;
    private int startOfFlacInFile;

    public FlacStreamReader(RandomAccessFile randomAccessFile) {
        this.raf = randomAccessFile;
    }

    public void findStream() throws IOException, CannotReadException {
        if (this.raf.length() == 0L) {
            throw new CannotReadException("Error: File empty");
        }
        this.raf.seek(0L);
        if (this.isFlacHeader()) {
            this.startOfFlacInFile = 0;
            return;
        }
        if (this.isId3v2Tag()) {
            this.startOfFlacInFile = (int)(this.raf.getFilePointer() - 4L);
            return;
        }
        throw new CannotReadException(ErrorMessage.FLAC_NO_FLAC_HEADER_FOUND.getMsg());
    }

    private boolean isId3v2Tag() throws IOException {
        this.raf.seek(0L);
        if (AbstractID3v2Tag.isId3Tag(this.raf)) {
            logger.warning(ErrorMessage.FLAC_CONTAINS_ID3TAG.getMsg(this.raf.getFilePointer()));
            if (this.isFlacHeader()) {
                return true;
            }
        }
        return false;
    }

    private boolean isFlacHeader() throws IOException {
        byte[] byArray = new byte[4];
        this.raf.read(byArray);
        String string = new String(byArray);
        return string.equals(FLAC_STREAM_IDENTIFIER);
    }

    public int getStartOfFlacInFile() {
        return this.startOfFlacInFile;
    }
}

