/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.logging.ErrorMessage;

public class Utils {
    public static final long DIFF_BETWEEN_ASF_DATE_AND_JAVA_DATE = 11644470000000L;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int MAXIMUM_STRING_LENGTH_ALLOWED = 32766;

    public static void checkStringLengthNullSafe(String string) throws IllegalArgumentException {
        if (string != null && string.length() > 32766) {
            throw new IllegalArgumentException(ErrorMessage.WMA_LENGTH_OF_STRING_IS_TOO_LARGE.getMsg(string.length() * 2));
        }
    }

    public static boolean isStringLengthValidNullSafe(String string) {
        return string == null || string.length() <= 32766;
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        for (long i = 0L; i < l; i += (long)n) {
            int n2 = 8192;
            if (l - i < 8192L) {
                n2 = (int)(l - i);
            }
            if ((n = inputStream.read(byArray, 0, n2)) == -1) {
                throw new IOException("Inputstream has to continue for another " + (l - i) + " bytes.");
            }
            outputStream.write(byArray, 0, n);
        }
    }

    public static void flush(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static byte[] getBytes(long l, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(l >>> i * 8 & 0xFFL);
        }
        return byArray;
    }

    public static byte[] getBytes(String string, Charset charset) {
        assert (charset != null);
        assert (string != null);
        ByteBuffer byteBuffer = charset.encode(string);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.rewind();
        byteBuffer.get(byArray);
        return byArray;
    }

    public static GregorianCalendar getDateOf(BigInteger bigInteger) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        BigInteger bigInteger2 = bigInteger.divide(new BigInteger("10"));
        Date date = new Date(bigInteger2.longValue() - 11644470000000L);
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    public static boolean isBlank(String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static BigInteger readBig64(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        int n = inputStream.read(byArray);
        if (n != 8) {
            throw new EOFException();
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[7 - i] = byArray[i];
        }
        return new BigInteger(byArray2);
    }

    public static byte[] readBinary(InputStream inputStream, long l) throws IOException {
        byte[] byArray = new byte[(int)l];
        inputStream.read(byArray);
        return byArray;
    }

    public static String readCharacterSizedString(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = Utils.readUINT16(inputStream);
        int n2 = inputStream.read();
        n2 |= inputStream.read() << 8;
        do {
            if (n2 == 0) continue;
            stringBuilder.append((char)n2);
            n2 = inputStream.read();
            n2 |= inputStream.read() << 8;
        } while (n2 != 0 || stringBuilder.length() + 1 > n);
        if (n != stringBuilder.length() + 1) {
            throw new IllegalStateException("Invalid Data for current interpretation");
        }
        return stringBuilder.toString();
    }

    public static String readFixedSizeUTF16Str(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 == byArray.length) {
            if (byArray.length >= 2 && byArray[byArray.length - 1] == 0 && byArray[byArray.length - 2] == 0) {
                byte[] byArray2 = new byte[byArray.length - 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length - 2);
                byArray = byArray2;
            }
            return new String(byArray, "UTF-16LE");
        }
        throw new IllegalStateException("Couldn't read the necessary amount of bytes.");
    }

    public static GUID readGUID(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        int[] nArray = new int[16];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = inputStream.read();
        }
        return new GUID(nArray);
    }

    public static int readUINT16(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        return n |= inputStream.read() << 8;
    }

    public static long readUINT32(InputStream inputStream) throws IOException {
        long l = 0L;
        for (int i = 0; i <= 24; i += 8) {
            l |= (long)inputStream.read() << i;
        }
        return l;
    }

    public static long readUINT64(InputStream inputStream) throws IOException {
        long l = 0L;
        for (int i = 0; i <= 56; i += 8) {
            l |= (long)inputStream.read() << i;
        }
        return l;
    }

    public static String readUTF16LEStr(InputStream inputStream) throws IOException {
        int n = Utils.readUINT16(inputStream);
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 == n || n == 0 && n2 == -1) {
            if (byArray.length >= 2 && byArray[byArray.length - 1] == 0 && byArray[byArray.length - 2] == 0) {
                byte[] byArray2 = new byte[byArray.length - 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length - 2);
                byArray = byArray2;
            }
            return new String(byArray, AsfHeader.ASF_CHARSET.name());
        }
        throw new IllegalStateException("Invalid Data for current interpretation");
    }

    public static void writeUINT16(int n, OutputStream outputStream) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("positive value expected.");
        }
        byte[] byArray = new byte[2];
        for (int i = 0; i <= 8; i += 8) {
            byArray[i / 8] = (byte)(n >> i & 0xFF);
        }
        outputStream.write(byArray);
    }

    public static void writeUINT32(long l, OutputStream outputStream) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("positive value expected.");
        }
        byte[] byArray = new byte[4];
        for (int i = 0; i <= 24; i += 8) {
            byArray[i / 8] = (byte)(l >> i & 0xFFL);
        }
        outputStream.write(byArray);
    }

    public static void writeUINT64(long l, OutputStream outputStream) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("positive value expected.");
        }
        byte[] byArray = new byte[8];
        for (int i = 0; i <= 56; i += 8) {
            byArray[i / 8] = (byte)(l >> i & 0xFFL);
        }
        outputStream.write(byArray);
    }
}

