/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.util;

import java.util.Iterator;
import java.util.List;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.MetadataContainer;
import org.jaudiotagger.audio.asf.data.MetadataContainerFactory;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.asf.AsfFieldKey;
import org.jaudiotagger.tag.asf.AsfTag;
import org.jaudiotagger.tag.asf.AsfTagBannerField;
import org.jaudiotagger.tag.asf.AsfTagCoverField;
import org.jaudiotagger.tag.asf.AsfTagField;
import org.jaudiotagger.tag.asf.AsfTagTextField;
import org.jaudiotagger.tag.reference.GenreTypes;

public final class TagConverter {
    public static void assignCommonTagValues(Tag tag, MetadataContainer metadataContainer) {
        MetadataDescriptor metadataDescriptor;
        assert (metadataContainer.getContainerType() == ContainerType.EXTENDED_CONTENT);
        if (!Utils.isBlank(tag.getFirst(FieldKey.ALBUM))) {
            metadataDescriptor = new MetadataDescriptor(metadataContainer.getContainerType(), AsfFieldKey.ALBUM.getFieldName(), 0);
            metadataDescriptor.setStringValue(tag.getFirst(FieldKey.ALBUM));
            metadataContainer.removeDescriptorsByName(metadataDescriptor.getName());
            metadataContainer.addDescriptor(metadataDescriptor);
        } else {
            metadataContainer.removeDescriptorsByName(AsfFieldKey.ALBUM.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirst(FieldKey.TRACK))) {
            metadataDescriptor = new MetadataDescriptor(metadataContainer.getContainerType(), AsfFieldKey.TRACK.getFieldName(), 0);
            metadataDescriptor.setStringValue(tag.getFirst(FieldKey.TRACK));
            metadataContainer.removeDescriptorsByName(metadataDescriptor.getName());
            metadataContainer.addDescriptor(metadataDescriptor);
        } else {
            metadataContainer.removeDescriptorsByName(AsfFieldKey.TRACK.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirst(FieldKey.YEAR))) {
            metadataDescriptor = new MetadataDescriptor(metadataContainer.getContainerType(), AsfFieldKey.YEAR.getFieldName(), 0);
            metadataDescriptor.setStringValue(tag.getFirst(FieldKey.YEAR));
            metadataContainer.removeDescriptorsByName(metadataDescriptor.getName());
            metadataContainer.addDescriptor(metadataDescriptor);
        } else {
            metadataContainer.removeDescriptorsByName(AsfFieldKey.YEAR.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirst(FieldKey.GENRE))) {
            metadataDescriptor = new MetadataDescriptor(metadataContainer.getContainerType(), AsfFieldKey.GENRE.getFieldName(), 0);
            metadataDescriptor.setStringValue(tag.getFirst(FieldKey.GENRE));
            metadataContainer.removeDescriptorsByName(metadataDescriptor.getName());
            metadataContainer.addDescriptor(metadataDescriptor);
            Integer n = GenreTypes.getInstanceOf().getIdForName(tag.getFirst(FieldKey.GENRE));
            if (n != null) {
                metadataDescriptor = new MetadataDescriptor(metadataContainer.getContainerType(), AsfFieldKey.GENRE_ID.getFieldName(), 0);
                metadataDescriptor.setStringValue("(" + n + ")");
                metadataContainer.removeDescriptorsByName(metadataDescriptor.getName());
                metadataContainer.addDescriptor(metadataDescriptor);
            } else {
                metadataContainer.removeDescriptorsByName(AsfFieldKey.GENRE_ID.getFieldName());
            }
        } else {
            metadataContainer.removeDescriptorsByName(AsfFieldKey.GENRE.getFieldName());
            metadataContainer.removeDescriptorsByName(AsfFieldKey.GENRE_ID.getFieldName());
        }
    }

    public static AsfTag createTagOf(AsfHeader asfHeader) {
        AsfTag asfTag = new AsfTag(true);
        for (int i = 0; i < ContainerType.values().length; ++i) {
            MetadataContainer metadataContainer = asfHeader.findMetadataContainer(ContainerType.values()[i]);
            if (metadataContainer == null) continue;
            List<MetadataDescriptor> list = metadataContainer.getDescriptors();
            for (MetadataDescriptor metadataDescriptor : list) {
                AsfTagField asfTagField = metadataDescriptor.getType() == 1 ? (metadataDescriptor.getName().equals(AsfFieldKey.COVER_ART.getFieldName()) ? new AsfTagCoverField(metadataDescriptor) : (metadataDescriptor.getName().equals(AsfFieldKey.BANNER_IMAGE.getFieldName()) ? new AsfTagBannerField(metadataDescriptor) : new AsfTagField(metadataDescriptor))) : new AsfTagTextField(metadataDescriptor);
                asfTag.addField(asfTagField);
            }
        }
        return asfTag;
    }

    public static MetadataContainer[] distributeMetadata(AsfTag asfTag) {
        Iterator<AsfTagField> iterator = asfTag.getAsfFields();
        MetadataContainer[] metadataContainerArray = MetadataContainerFactory.getInstance().createContainers(ContainerType.getOrdered());
        while (iterator.hasNext()) {
            AsfTagField asfTagField = iterator.next();
            boolean bl = false;
            for (int i = 0; !bl && i < metadataContainerArray.length; ++i) {
                if (!ContainerType.areInCorrectOrder(metadataContainerArray[i].getContainerType(), AsfFieldKey.getAsfFieldKey(asfTagField.getId()).getHighestContainer()) || !metadataContainerArray[i].isAddSupported(asfTagField.getDescriptor())) continue;
                metadataContainerArray[i].addDescriptor(asfTagField.getDescriptor());
                bl = true;
            }
            assert (bl);
        }
        return metadataContainerArray;
    }

    private TagConverter() {
    }
}

