/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.ModificationResult;
import org.jaudiotagger.audio.asf.util.Utils;

public class ChunkRemover
implements ChunkModifier {
    private final Set<GUID> toRemove = new HashSet<GUID>();

    public ChunkRemover(GUID ... gUIDArray) {
        for (GUID gUID : gUIDArray) {
            this.toRemove.add(gUID);
        }
    }

    @Override
    public boolean isApplicable(GUID gUID) {
        return this.toRemove.contains(gUID);
    }

    @Override
    public ModificationResult modify(GUID gUID, InputStream inputStream, OutputStream outputStream) throws IOException {
        ModificationResult modificationResult;
        if (gUID == null) {
            modificationResult = new ModificationResult(0, 0L, new GUID[0]);
        } else {
            assert (this.isApplicable(gUID));
            long l = Utils.readUINT64(inputStream);
            inputStream.skip(l - 24L);
            modificationResult = new ModificationResult(-1, -1L * l, gUID);
        }
        return modificationResult;
    }
}

