/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;
import org.jaudiotagger.audio.asf.data.AsfExtendedHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkContainerReader;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class AsfExtHeaderReader
extends ChunkContainerReader<AsfExtendedHeader> {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_HEADER_EXTENSION};

    public AsfExtHeaderReader(List<Class<? extends ChunkReader>> list, boolean bl) {
        super(list, bl);
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    protected AsfExtendedHeader createContainer(long l, BigInteger bigInteger, InputStream inputStream) throws IOException {
        Utils.readGUID(inputStream);
        Utils.readUINT16(inputStream);
        long l2 = Utils.readUINT32(inputStream);
        assert (l2 == 0L || l2 >= 24L);
        assert (bigInteger.subtract(BigInteger.valueOf(46L)).longValue() == l2);
        return new AsfExtendedHeader(l, bigInteger);
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }
}

