/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public abstract class StreamChunk
extends Chunk {
    private boolean contentEncrypted;
    private int streamNumber;
    private long streamSpecificDataSize;
    private long timeOffset;
    private final GUID type;
    private long typeSpecificDataSize;

    public StreamChunk(GUID gUID, BigInteger bigInteger) {
        super(GUID.GUID_STREAM, bigInteger);
        assert (GUID.GUID_AUDIOSTREAM.equals(gUID) || GUID.GUID_VIDEOSTREAM.equals(gUID));
        this.type = gUID;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public long getStreamSpecificDataSize() {
        return this.streamSpecificDataSize;
    }

    public GUID getStreamType() {
        return this.type;
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public long getTypeSpecificDataSize() {
        return this.typeSpecificDataSize;
    }

    public boolean isContentEncrypted() {
        return this.contentEncrypted;
    }

    @Override
    public String prettyPrint(String string) {
        StringBuilder stringBuilder = new StringBuilder(super.prettyPrint(string));
        stringBuilder.append(string).append("  |-> Stream number: ").append(this.getStreamNumber()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |-> Type specific data size  : ").append(this.getTypeSpecificDataSize()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |-> Stream specific data size: ").append(this.getStreamSpecificDataSize()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |-> Time Offset              : ").append(this.getTimeOffset()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |-> Content Encryption       : ").append(this.isContentEncrypted()).append(Utils.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    public void setContentEncrypted(boolean bl) {
        this.contentEncrypted = bl;
    }

    public void setStreamNumber(int n) {
        this.streamNumber = n;
    }

    public void setStreamSpecificDataSize(long l) {
        this.streamSpecificDataSize = l;
    }

    public void setTimeOffset(long l) {
        this.timeOffset = l;
    }

    public void setTypeSpecificDataSize(long l) {
        this.typeSpecificDataSize = l;
    }
}

