/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jaudiotagger.audio.asf.data.GUIDFormatException;
import org.jaudiotagger.audio.asf.util.Utils;

public final class GUID {
    public static final GUID GUID_AUDIO_ERROR_CONCEALEMENT_ABSENT = new GUID(new int[]{64, 164, 241, 73, 206, 78, 208, 17, 163, 172, 0, 160, 201, 3, 72, 246}, "Audio error concealment absent.");
    public static final GUID GUID_AUDIO_ERROR_CONCEALEMENT_INTERLEAVED = new GUID(new int[]{64, 164, 241, 73, 206, 78, 208, 17, 163, 172, 0, 160, 201, 3, 72, 246}, "Interleaved audio error concealment.");
    public static final GUID GUID_AUDIOSTREAM = new GUID(new int[]{64, 158, 105, 248, 77, 91, 207, 17, 168, 253, 0, 128, 95, 92, 68, 43}, " Audio stream");
    public static final GUID GUID_CONTENT_BRANDING = new GUID(new int[]{250, 179, 17, 34, 35, 189, 210, 17, 180, 183, 0, 160, 201, 85, 252, 110}, "Content Branding");
    public static final GUID GUID_CONTENT_ENCRYPTION = new GUID(new int[]{251, 179, 17, 34, 35, 189, 210, 17, 180, 183, 0, 160, 201, 85, 252, 110}, "Content Encryption Object");
    public static final GUID GUID_CONTENTDESCRIPTION = new GUID(new int[]{51, 38, 178, 117, 142, 102, 207, 17, 166, 217, 0, 170, 0, 98, 206, 108}, "Content Description");
    public static final GUID GUID_ENCODING = new GUID(new int[]{64, 82, 209, 134, 29, 49, 208, 17, 163, 164, 0, 160, 201, 3, 72, 246}, "Encoding description");
    public static final GUID GUID_EXTENDED_CONTENT_DESCRIPTION = new GUID(new int[]{64, 164, 208, 210, 7, 227, 210, 17, 151, 240, 0, 160, 201, 94, 168, 80}, "Extended Content Description");
    public static final GUID GUID_FILE = new GUID(new int[]{161, 220, 171, 140, 71, 169, 207, 17, 142, 228, 0, 192, 12, 32, 83, 101}, "File header");
    public static final GUID GUID_HEADER = new GUID(new int[]{48, 38, 178, 117, 142, 102, 207, 17, 166, 217, 0, 170, 0, 98, 206, 108}, "Asf header");
    public static final GUID GUID_HEADER_EXTENSION = new GUID(new int[]{181, 3, 191, 95, 46, 169, 207, 17, 142, 227, 0, 192, 12, 32, 83, 101}, "Header Extension");
    public static final GUID GUID_LANGUAGE_LIST = new GUID(new int[]{169, 70, 67, 124, 224, 239, 252, 75, 178, 41, 57, 62, 222, 65, 92, 133}, "Language List");
    public static final int GUID_LENGTH = 16;
    public static final GUID GUID_METADATA = new GUID(new int[]{234, 203, 248, 197, 175, 91, 119, 72, 132, 103, 170, 140, 68, 250, 76, 202}, "Metadata");
    public static final GUID GUID_METADATA_LIBRARY = new GUID(new int[]{148, 28, 35, 68, 152, 148, 209, 73, 161, 65, 29, 19, 78, 69, 112, 84}, "Metadata Library");
    private static final Pattern GUID_PATTERN = Pattern.compile("[a-f0-9]{8}\\-[a-f0-9]{4}\\-[a-f0-9]{4}\\-[a-f0-9]{4}\\-[a-f0-9]{12}", 2);
    public static final GUID GUID_STREAM = new GUID(new int[]{145, 7, 220, 183, 183, 169, 207, 17, 142, 230, 0, 192, 12, 32, 83, 101}, "Stream");
    public static final GUID GUID_STREAM_BITRATE_PROPERTIES = new GUID(new int[]{206, 117, 248, 123, 141, 70, 209, 17, 141, 130, 0, 96, 151, 201, 162, 178}, "Stream bitrate properties");
    private static final Map<GUID, GUID> GUID_TO_CONFIGURED;
    public static final GUID GUID_UNSPECIFIED;
    public static final GUID GUID_VIDEOSTREAM;
    public static final GUID[] KNOWN_GUIDS;
    public static final GUID SCRIPT_COMMAND_OBJECT;
    private String description = "";
    private int[] guidData = null;
    private int hash;

    public static boolean assertGUID(int[] nArray) {
        return nArray != null && nArray.length == 16;
    }

    public static GUID getConfigured(GUID gUID) {
        return GUID_TO_CONFIGURED.get(gUID);
    }

    public static String getGuidDescription(GUID gUID) {
        String string = null;
        if (gUID == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        if (GUID.getConfigured(gUID) != null) {
            string = GUID.getConfigured(gUID).getDescription();
        }
        return string;
    }

    public static GUID parseGUID(String string) throws GUIDFormatException {
        if (string == null) {
            throw new GUIDFormatException("null");
        }
        if (!GUID_PATTERN.matcher(string).matches()) {
            throw new GUIDFormatException("Invalid guidData format.");
        }
        int[] nArray = new int[16];
        int[] nArray2 = new int[]{3, 2, 1, 0, 5, 4, 7, 6, 8, 9, 10, 11, 12, 13, 14, 15};
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '-') continue;
            nArray[nArray2[n++]] = Integer.parseInt(string.substring(i, i + 2), 16);
            ++i;
        }
        return new GUID(nArray);
    }

    public GUID(byte[] byArray) {
        assert (byArray != null);
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = 0xFF & byArray[i];
        }
        this.setGUID(nArray);
    }

    public GUID(int[] nArray) {
        this.setGUID(nArray);
    }

    public GUID(int[] nArray, String string) {
        this(nArray);
        if (string == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.description = string;
    }

    public GUID(String string, String string2) {
        this(GUID.parseGUID(string).getGUID());
        if (string2 == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.description = string2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof GUID) {
            GUID gUID = (GUID)object;
            bl = Arrays.equals(this.getGUID(), gUID.getGUID());
        }
        return bl;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.guidData.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(this.guidData[i] & 0xFF);
        }
        return byArray;
    }

    public String getDescription() {
        return this.description;
    }

    public int[] getGUID() {
        int[] nArray = new int[this.guidData.length];
        System.arraycopy(this.guidData, 0, nArray, 0, this.guidData.length);
        return nArray;
    }

    private String[] getHex(byte[] byArray) {
        String[] stringArray = new String[byArray.length];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append(Integer.toHexString(0xFF & byArray[i]));
            if (stringBuilder.length() == 1) {
                stringBuilder.insert(0, "0");
            }
            stringArray[i] = stringBuilder.toString();
        }
        return stringArray;
    }

    public int hashCode() {
        if (this.hash == -1) {
            int n = 0;
            for (int n2 : this.getGUID()) {
                n = n * 31 + n2;
            }
            this.hash = n;
        }
        return this.hash;
    }

    public boolean isValid() {
        return GUID.assertGUID(this.getGUID());
    }

    public String prettyPrint() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getDescription();
        if (Utils.isBlank(string)) {
            string = GUID.getGuidDescription(this);
        }
        if (!Utils.isBlank(string)) {
            stringBuilder.append("Description: ").append(string).append(Utils.LINE_SEPARATOR).append("   ");
        }
        stringBuilder.append(this.toString());
        return stringBuilder.toString();
    }

    private void setGUID(int[] nArray) {
        if (!GUID.assertGUID(nArray)) {
            throw new IllegalArgumentException("The given guidData doesn't match the GUID specification.");
        }
        this.guidData = new int[16];
        System.arraycopy(nArray, 0, this.guidData, 0, 16);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.getHex(this.getBytes());
        stringBuilder.append(stringArray[3]);
        stringBuilder.append(stringArray[2]);
        stringBuilder.append(stringArray[1]);
        stringBuilder.append(stringArray[0]);
        stringBuilder.append('-');
        stringBuilder.append(stringArray[5]);
        stringBuilder.append(stringArray[4]);
        stringBuilder.append('-');
        stringBuilder.append(stringArray[7]);
        stringBuilder.append(stringArray[6]);
        stringBuilder.append('-');
        stringBuilder.append(stringArray[8]);
        stringBuilder.append(stringArray[9]);
        stringBuilder.append('-');
        stringBuilder.append(stringArray[10]);
        stringBuilder.append(stringArray[11]);
        stringBuilder.append(stringArray[12]);
        stringBuilder.append(stringArray[13]);
        stringBuilder.append(stringArray[14]);
        stringBuilder.append(stringArray[15]);
        return stringBuilder.toString();
    }

    static {
        GUID_UNSPECIFIED = new GUID(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, "Unspecified");
        GUID_VIDEOSTREAM = new GUID(new int[]{192, 239, 25, 188, 77, 91, 207, 17, 168, 253, 0, 128, 95, 92, 68, 43}, "Video stream");
        SCRIPT_COMMAND_OBJECT = new GUID(new int[]{48, 26, 251, 30, 98, 11, 208, 17, 163, 155, 0, 160, 201, 3, 72, 246}, "Script Command Object");
        KNOWN_GUIDS = new GUID[]{GUID_AUDIO_ERROR_CONCEALEMENT_ABSENT, GUID_CONTENTDESCRIPTION, GUID_AUDIOSTREAM, GUID_ENCODING, GUID_FILE, GUID_HEADER, GUID_STREAM, GUID_EXTENDED_CONTENT_DESCRIPTION, GUID_VIDEOSTREAM, GUID_HEADER_EXTENSION, GUID_STREAM_BITRATE_PROPERTIES, SCRIPT_COMMAND_OBJECT, GUID_CONTENT_ENCRYPTION, GUID_CONTENT_BRANDING, GUID_UNSPECIFIED, GUID_METADATA_LIBRARY, GUID_METADATA, GUID_LANGUAGE_LIST};
        GUID_TO_CONFIGURED = new HashMap<GUID, GUID>(KNOWN_GUIDS.length);
        for (GUID gUID : KNOWN_GUIDS) {
            assert (!GUID_TO_CONFIGURED.containsKey(gUID)) : "Double definition: \"" + GUID_TO_CONFIGURED.get(gUID).getDescription() + "\" <-> \"" + gUID.getDescription() + "\"";
            GUID_TO_CONFIGURED.put(gUID, gUID);
        }
    }
}

