/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.ChunkPositionComparator;
import org.jaudiotagger.audio.asf.util.Utils;

public class ChunkContainer
extends Chunk {
    private static final Set<GUID> MULTI_CHUNKS = new HashSet<GUID>();
    private final Map<GUID, List<Chunk>> chunkTable = new Hashtable<GUID, List<Chunk>>();

    protected static boolean chunkstartsUnique(ChunkContainer chunkContainer) {
        boolean bl = true;
        HashSet<Long> hashSet = new HashSet<Long>();
        Collection<Chunk> collection = chunkContainer.getChunks();
        for (Chunk chunk : collection) {
            bl &= hashSet.add(chunk.getPosition());
        }
        return bl;
    }

    public ChunkContainer(GUID gUID, long l, BigInteger bigInteger) {
        super(gUID, l, bigInteger);
    }

    public void addChunk(Chunk chunk) {
        List<Chunk> list = this.assertChunkList(chunk.getGuid());
        if (!list.isEmpty() && !MULTI_CHUNKS.contains(chunk.getGuid())) {
            throw new IllegalArgumentException("The GUID of the given chunk indicates, that there is no more instance allowed.");
        }
        list.add(chunk);
        assert (ChunkContainer.chunkstartsUnique(this)) : "Chunk has equal start position like an already inserted one.";
    }

    protected List<Chunk> assertChunkList(GUID gUID) {
        List<Chunk> list = this.chunkTable.get(gUID);
        if (list == null) {
            list = new ArrayList<Chunk>();
            this.chunkTable.put(gUID, list);
        }
        return list;
    }

    public Collection<Chunk> getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (List<Chunk> list : this.chunkTable.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    protected Chunk getFirst(GUID gUID, Class<? extends Chunk> clazz) {
        Chunk chunk;
        Chunk chunk2 = null;
        List<Chunk> list = this.chunkTable.get(gUID);
        if (list != null && !list.isEmpty() && clazz.isAssignableFrom((chunk = list.get(0)).getClass())) {
            chunk2 = chunk;
        }
        return chunk2;
    }

    public boolean hasChunkByGUID(GUID gUID) {
        return this.chunkTable.containsKey(gUID);
    }

    @Override
    public String prettyPrint(String string) {
        return this.prettyPrint(string, "");
    }

    public String prettyPrint(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(super.prettyPrint(string));
        stringBuilder.append(string2);
        stringBuilder.append(string).append("  |").append(Utils.LINE_SEPARATOR);
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>(this.getChunks());
        Collections.sort(arrayList, new ChunkPositionComparator());
        for (Chunk chunk : arrayList) {
            stringBuilder.append(chunk.prettyPrint(string + "  |"));
            stringBuilder.append(string).append("  |").append(Utils.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    static {
        MULTI_CHUNKS.add(GUID.GUID_STREAM);
    }
}

