/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.MetadataContainer;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.io.AsfExtHeaderReader;
import org.jaudiotagger.audio.asf.io.AsfHeaderReader;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.io.ContentBrandingReader;
import org.jaudiotagger.audio.asf.io.ContentDescriptionReader;
import org.jaudiotagger.audio.asf.io.FileHeaderReader;
import org.jaudiotagger.audio.asf.io.FullRequestInputStream;
import org.jaudiotagger.audio.asf.io.LanguageListReader;
import org.jaudiotagger.audio.asf.io.MetadataReader;
import org.jaudiotagger.audio.asf.io.StreamChunkReader;
import org.jaudiotagger.audio.asf.util.TagConverter;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.asf.AsfTag;

public class AsfFileReader
extends AudioFileReader {
    private static final Logger LOGGER = Logger.getLogger("org.jaudiotagger.audio.asf");
    private static final AsfHeaderReader HEADER_READER;

    private boolean determineVariableBitrate(AsfHeader asfHeader) {
        List<MetadataDescriptor> list;
        assert (asfHeader != null);
        boolean bl = false;
        MetadataContainer metadataContainer = asfHeader.findExtendedContentDescription();
        if (metadataContainer != null && (list = metadataContainer.getDescriptorsByName("IsVBR")) != null && !list.isEmpty()) {
            bl = Boolean.TRUE.toString().equals(list.get(0).getString());
        }
        return bl;
    }

    private GenericAudioHeader getAudioHeader(AsfHeader asfHeader) throws CannotReadException {
        GenericAudioHeader genericAudioHeader = new GenericAudioHeader();
        if (asfHeader.getFileHeader() == null) {
            throw new CannotReadException("Invalid ASF/WMA file. File header object not available.");
        }
        if (asfHeader.getAudioStreamChunk() == null) {
            throw new CannotReadException("Invalid ASF/WMA file. No audio stream contained.");
        }
        genericAudioHeader.setBitrate(asfHeader.getAudioStreamChunk().getKbps());
        genericAudioHeader.setChannelNumber((int)asfHeader.getAudioStreamChunk().getChannelCount());
        genericAudioHeader.setEncodingType("ASF (audio): " + asfHeader.getAudioStreamChunk().getCodecDescription());
        genericAudioHeader.setLossless(asfHeader.getAudioStreamChunk().getCompressionFormat() == 355L);
        genericAudioHeader.setPreciseLength(asfHeader.getFileHeader().getPreciseDuration());
        genericAudioHeader.setSamplingRate((int)asfHeader.getAudioStreamChunk().getSamplingRate());
        genericAudioHeader.setVariableBitRate(this.determineVariableBitrate(asfHeader));
        genericAudioHeader.setBitsPerSample(asfHeader.getAudioStreamChunk().getBitsPerSample());
        return genericAudioHeader;
    }

    @Override
    protected GenericAudioHeader getEncodingInfo(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        GenericAudioHeader genericAudioHeader;
        randomAccessFile.seek(0L);
        try {
            AsfHeader asfHeader = AsfHeaderReader.readInfoHeader(randomAccessFile);
            if (asfHeader == null) {
                throw new CannotReadException("Some values must have been incorrect for interpretation as asf with wma content.");
            }
            genericAudioHeader = this.getAudioHeader(asfHeader);
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CannotReadException) {
                throw (CannotReadException)exception;
            }
            throw new CannotReadException("Failed to read. Cause: " + exception.getMessage(), exception);
        }
        return genericAudioHeader;
    }

    private AsfTag getTag(AsfHeader asfHeader) {
        return TagConverter.createTagOf(asfHeader);
    }

    @Override
    protected AsfTag getTag(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        AsfTag asfTag;
        randomAccessFile.seek(0L);
        try {
            AsfHeader asfHeader = AsfHeaderReader.readTagHeader(randomAccessFile);
            if (asfHeader == null) {
                throw new CannotReadException("Some values must have been incorrect for interpretation as asf with wma content.");
            }
            asfTag = TagConverter.createTagOf(asfHeader);
        }
        catch (Exception exception) {
            logger.severe(exception.getMessage());
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CannotReadException) {
                throw (CannotReadException)exception;
            }
            throw new CannotReadException("Failed to read. Cause: " + exception.getMessage());
        }
        return asfTag;
    }

    @Override
    public AudioFile read(File file) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        if (!file.canRead()) {
            throw new CannotReadException(ErrorMessage.GENERAL_READ_FAILED_DO_NOT_HAVE_PERMISSION_TO_READ_FILE.getMsg(file.getAbsolutePath()));
        }
        InputStream inputStream = null;
        try {
            inputStream = new FullRequestInputStream(new BufferedInputStream(new FileInputStream(file)));
            AsfHeader asfHeader = (AsfHeader)HEADER_READER.read(Utils.readGUID(inputStream), inputStream, 0L);
            if (asfHeader == null) {
                throw new CannotReadException(ErrorMessage.ASF_HEADER_MISSING.getMsg(file.getAbsolutePath()));
            }
            if (asfHeader.getFileHeader() == null) {
                throw new CannotReadException(ErrorMessage.ASF_FILE_HEADER_MISSING.getMsg(file.getAbsolutePath()));
            }
            if (asfHeader.getFileHeader().getFileSize().longValue() != file.length()) {
                logger.warning(ErrorMessage.ASF_FILE_HEADER_SIZE_DOES_NOT_MATCH_FILE_SIZE.getMsg(file.getAbsolutePath(), asfHeader.getFileHeader().getFileSize().longValue(), file.length()));
            }
            AudioFile audioFile = new AudioFile(file, (AudioHeader)this.getAudioHeader(asfHeader), (Tag)this.getTag(asfHeader));
            return audioFile;
        }
        catch (CannotReadException cannotReadException) {
            throw cannotReadException;
        }
        catch (Exception exception) {
            throw new CannotReadException("\"" + file + "\" :" + exception, exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                LOGGER.severe("\"" + file + "\" :" + exception);
            }
        }
    }

    static {
        ArrayList<Class<? extends ChunkReader>> arrayList = new ArrayList<Class<? extends ChunkReader>>();
        arrayList.add(ContentDescriptionReader.class);
        arrayList.add(ContentBrandingReader.class);
        arrayList.add(MetadataReader.class);
        arrayList.add(LanguageListReader.class);
        AsfExtHeaderReader asfExtHeaderReader = new AsfExtHeaderReader(arrayList, true);
        arrayList.add(FileHeaderReader.class);
        arrayList.add(StreamChunkReader.class);
        HEADER_READER = new AsfHeaderReader(arrayList, true);
        HEADER_READER.setExtendedHeaderReader(asfExtHeaderReader);
    }
}

