/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.jaudiotagger.audio.aiff.ExtDouble;

public class AiffUtil {
    private static final SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final Charset LATIN1 = (Charset)Charset.availableCharsets().get("ISO-8859-1");

    public static long readUINT32(RandomAccessFile randomAccessFile) throws IOException {
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            l <<= 8;
            l |= (long)randomAccessFile.read();
        }
        return l;
    }

    public static String read4Chars(RandomAccessFile randomAccessFile) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            char c = (char)randomAccessFile.read();
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static double read80BitDouble(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[10];
        randomAccessFile.readFully(byArray);
        ExtDouble extDouble = new ExtDouble(byArray);
        return extDouble.toDouble();
    }

    public static Date timestampToDate(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1904, 0, 1, 0, 0, 0);
        int n = (int)(l / 3600L);
        int n2 = (int)(l - (long)n * 3600L);
        calendar.add(11, n);
        calendar.add(13, n2);
        Date date = calendar.getTime();
        return date;
    }

    public static String formatDate(Date date) {
        return dateFmt.format(date);
    }

    public static String bytesToPascalString(byte[] byArray) {
        byte by = byArray[0];
        return new String(byArray, 0, (int)by, LATIN1);
    }

    public static String readPascalString(RandomAccessFile randomAccessFile) throws IOException {
        int n = randomAccessFile.read();
        byte[] byArray = new byte[n + 1];
        randomAccessFile.read(byArray, 1, n);
        byArray[0] = (byte)n;
        return AiffUtil.bytesToPascalString(byArray);
    }
}

