/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.code;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class SwitchSource {
    private ArrayList<String> enable = new ArrayList();
    private ArrayList<String> disable = new ArrayList();

    public static void main(String ... stringArray) throws IOException {
        new SwitchSource().run(stringArray);
    }

    private void run(String ... stringArray) throws IOException {
        String string = null;
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            String string4 = stringArray[i];
            if ("-dir".equals(string4)) {
                string = stringArray[++i];
                continue;
            }
            if ("-auto".equals(string4)) {
                this.enable.add("AWT");
                string2 = System.getProperty("java.specification.version");
                continue;
            }
            if ("-version".equals(string4)) {
                string2 = stringArray[++i];
                continue;
            }
            if (string4.startsWith("-")) {
                string3 = string4.substring(1);
                this.disable.add(string3);
                this.enable.remove(string3);
                continue;
            }
            if (string4.startsWith("+")) {
                string3 = string4.substring(1);
                this.enable.add(string3);
                this.disable.remove(string3);
                continue;
            }
            this.showUsage();
            return;
        }
        if (string2 != null) {
            if ("1.5".equals(string2)) {
                this.disable.add("Java 1.6");
                this.disable.add("Java 1.7");
            } else if ("1.6".equals(string2)) {
                this.enable.add("Java 1.6");
                this.disable.add("Java 1.7");
            } else if (string2.compareTo("1.7") >= 0) {
                this.enable.add("Java 1.6");
                this.enable.add("Java 1.7");
            } else {
                throw new IllegalArgumentException("version: " + string2);
            }
        }
        if (string == null) {
            this.showUsage();
        } else {
            this.process(new File(string));
        }
    }

    private void showUsage() {
        System.out.println("Switched source code to a specific Java version.");
        System.out.println("java " + this.getClass().getName() + "\n" + " -dir <dir>  The target directory\n" + " [-version]   Use the specified Java version (1.4 or newer)\n" + " [-auto]      Auto-detect Java version (1.4 or newer)\n" + " [+MODE]     Enable code labeled MODE\n" + " [-MODE]     Disable code labeled MODE");
    }

    private void process(File file) throws IOException {
        String string = file.getName();
        if (string.startsWith(".svn")) {
            return;
        }
        if (string.endsWith(".java")) {
            this.processFile(file);
        } else if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.process(file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(File file) throws IOException {
        String string;
        byte[] byArray;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            long l = randomAccessFile.length();
            if (l >= Integer.MAX_VALUE) {
                throw new IOException("Files bigger than Integer.MAX_VALUE are not supported");
            }
            byArray = new byte[(int)l];
            randomAccessFile.readFully(byArray);
        }
        finally {
            randomAccessFile.close();
        }
        boolean bl = false;
        for (int i = 0; i < byArray.length - 1; ++i) {
            if (byArray[i] != 35 || byArray[i + 1] != 35) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        String string2 = string = new String(byArray);
        for (String object : this.enable) {
            string2 = SwitchSource.replaceAll(string2, "/*## " + object + " ##", "//## " + object + " ##");
        }
        for (String string3 : this.disable) {
            string2 = SwitchSource.replaceAll(string2, "//## " + string3 + " ##", "/*## " + string3 + " ##");
        }
        if (!string.equals(string2)) {
            String string3 = file.getPath();
            File file2 = new File((String)string3 + ".new");
            FileWriter fileWriter = new FileWriter(file2);
            fileWriter.write(string2);
            fileWriter.close();
            File file3 = new File((String)string3 + ".bak");
            file3.delete();
            file.renameTo(file3);
            File file4 = new File(string3);
            if (!file2.renameTo(file4)) {
                throw new IOException("Could not rename " + file2.getAbsolutePath() + " to " + (String)string3);
            }
            if (!file3.delete()) {
                throw new IOException("Could not delete " + file3.getAbsolutePath());
            }
        }
    }

    private static String replaceAll(String string, String string2, String string3) {
        int n = 0;
        int n2;
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            string = string.substring(0, n2) + string3 + string.substring(n2 + string2.length());
            n = n2 + string3.length();
        }
        return string;
    }
}

