/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.setting.AbstractSetting;

public class FileSetSetting
extends AbstractSetting {
    private Set<File> value;

    FileSetSetting(Properties properties, Properties properties2, String string, File[] fileArray) {
        super(properties, properties2, string, FileSetSetting.decode(new HashSet<File>(Arrays.asList(fileArray))));
        this.setPrivate(true);
    }

    public Set<File> getValue() {
        return this.value;
    }

    public synchronized File[] getValueAsArray() {
        return this.value.toArray(new File[this.value.size()]);
    }

    public void setValue(Set<? extends File> set) {
        this.setValueInternal(FileSetSetting.decode(set));
    }

    public synchronized void add(File file) {
        this.value.add(file);
        this.setValue(this.value);
    }

    public synchronized boolean remove(File file) {
        if (this.value.remove(file)) {
            this.setValue(this.value);
            return true;
        }
        return false;
    }

    public synchronized boolean contains(File file) {
        return this.value.contains(file);
    }

    public synchronized int length() {
        return this.value.size();
    }

    @Override
    protected synchronized void loadValue(String string) {
        this.value = FileSetSetting.encode(string);
    }

    private static final Set<File> encode(String string) {
        if (string == null || string.length() == 0) {
            return new HashSet<File>();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        HashSet<File> hashSet = new HashSet<File>();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new File(stringTokenizer.nextToken()));
        }
        return hashSet;
    }

    private static final String decode(Set<? extends File> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : set) {
            stringBuilder.append(file.getAbsolutePath()).append(';');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public synchronized void clean() {
        Iterator<File> iterator = this.value.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (file.exists()) continue;
            iterator.remove();
        }
        this.setValue(this.value);
    }
}

