/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Packed64
extends PackedInts.ReaderImpl
implements PackedInts.Mutable {
    static final int BLOCK_SIZE = 64;
    static final int BLOCK_BITS = 6;
    static final int MOD_MASK = 63;
    private static final int ENTRY_SIZE = 65;
    private static final int FAC_BITPOS = 3;
    private static final int[][] SHIFTS;
    private static final long[][] MASKS;
    private static final long[][] WRITE_MASKS;
    private long[] blocks;
    private int maxPos;
    private int[] shifts;
    private long[] readMasks;
    private long[] writeMasks;

    public Packed64(int n, int n2) {
        this(new long[(int)((long)n * (long)n2 / 64L + 2L)], n, n2);
    }

    public Packed64(long[] lArray, int n, int n2) {
        super(n, n2);
        this.blocks = lArray;
        this.updateCached();
    }

    public Packed64(DataInput dataInput, int n, int n2) throws IOException {
        super(n, n2);
        int n3 = Packed64.size(n, n2);
        this.blocks = new long[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            this.blocks[i] = dataInput.readLong();
        }
        this.updateCached();
    }

    private static int size(int n, int n2) {
        long l = (long)n * (long)n2;
        return (int)(l / 64L + (long)(l % 64L == 0L ? 0 : 1));
    }

    private void updateCached() {
        this.readMasks = MASKS[this.bitsPerValue];
        this.shifts = SHIFTS[this.bitsPerValue];
        this.writeMasks = WRITE_MASKS[this.bitsPerValue];
        this.maxPos = (int)((long)this.blocks.length * 64L / (long)this.bitsPerValue - 2L);
    }

    @Override
    public long get(int n) {
        long l = (long)n * (long)this.bitsPerValue;
        int n2 = (int)(l >>> 6);
        int n3 = (int)(l & 0x3FL);
        int n4 = n3 * 3;
        assert (n2 < this.blocks.length) : "elementPos: " + n2 + "; blocks.len: " + this.blocks.length;
        return this.blocks[n2] << this.shifts[n4] >>> this.shifts[n4 + 1] | this.blocks[n2 + 1] >>> this.shifts[n4 + 2] & this.readMasks[n3];
    }

    @Override
    public void set(int n, long l) {
        long l2 = (long)n * (long)this.bitsPerValue;
        int n2 = (int)(l2 >>> 6);
        int n3 = (int)(l2 & 0x3FL);
        int n4 = n3 * 3;
        this.blocks[n2] = this.blocks[n2] & this.writeMasks[n4] | l << this.shifts[n4 + 1] >>> this.shifts[n4];
        this.blocks[n2 + 1] = this.blocks[n2 + 1] & this.writeMasks[n4 + 1] | l << this.shifts[n4 + 2] & this.writeMasks[n4 + 2];
    }

    public String toString() {
        return "Packed64(bitsPerValue=" + this.bitsPerValue + ", size=" + this.size() + ", maxPos=" + this.maxPos + ", elements.length=" + this.blocks.length + ")";
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.blocks.length * 8;
    }

    @Override
    public void clear() {
        Arrays.fill(this.blocks, 0L);
    }

    static {
        int n;
        SHIFTS = new int[65][195];
        MASKS = new long[65][65];
        for (n = 1; n <= 64; ++n) {
            for (int i = 0; i < 64; ++i) {
                int[] nArray = SHIFTS[n];
                int n2 = i * 3;
                nArray[n2] = i;
                nArray[n2 + 1] = 64 - n;
                if (i <= 64 - n) {
                    nArray[n2 + 2] = 0;
                    Packed64.MASKS[n][i] = 0L;
                    continue;
                }
                int n3 = n - (64 - i);
                nArray[n2 + 2] = 64 - n3;
                Packed64.MASKS[n][i] = -1L << n3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        WRITE_MASKS = new long[65][195];
        for (n = 1; n <= 64; ++n) {
            long l = -1L << n ^ 0xFFFFFFFFFFFFFFFFL;
            int[] nArray = SHIFTS[n];
            long[] lArray = WRITE_MASKS[n];
            for (int i = 0; i < 64; ++i) {
                int n4 = i * 3;
                lArray[n4] = l << nArray[n4 + 1] >>> nArray[n4] ^ 0xFFFFFFFFFFFFFFFFL;
                if (i <= 64 - n) {
                    lArray[n4 + 1] = -1L;
                    lArray[n4 + 2] = 0L;
                    continue;
                }
                lArray[n4 + 1] = l << nArray[n4 + 2] ^ 0xFFFFFFFFFFFFFFFFL;
                lArray[n4 + 2] = nArray[n4 + 2] == 0 ? 0L : -1L;
            }
        }
    }
}

