/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.Outputs;

public final class IntSequenceOutputs
extends Outputs<IntsRef> {
    private static final IntsRef NO_OUTPUT = new IntsRef();

    private IntSequenceOutputs() {
    }

    public static IntSequenceOutputs getSingleton() {
        return new IntSequenceOutputs();
    }

    @Override
    public IntsRef common(IntsRef intsRef, IntsRef intsRef2) {
        assert (intsRef != null);
        assert (intsRef2 != null);
        int n = intsRef.offset;
        int n2 = intsRef2.offset;
        int n3 = n + Math.min(intsRef.length, intsRef2.length);
        while (n < n3 && intsRef.ints[n] == intsRef2.ints[n2]) {
            ++n;
            ++n2;
        }
        if (n == intsRef.offset) {
            return NO_OUTPUT;
        }
        if (n == intsRef.offset + intsRef.length) {
            return intsRef;
        }
        if (n2 == intsRef2.offset + intsRef2.length) {
            return intsRef2;
        }
        return new IntsRef(intsRef.ints, intsRef.offset, n - intsRef.offset);
    }

    @Override
    public IntsRef subtract(IntsRef intsRef, IntsRef intsRef2) {
        assert (intsRef != null);
        assert (intsRef2 != null);
        if (intsRef2 == NO_OUTPUT) {
            return intsRef;
        }
        if (intsRef2.length == intsRef.length) {
            return NO_OUTPUT;
        }
        assert (intsRef2.length < intsRef.length) : "inc.length=" + intsRef2.length + " vs output.length=" + intsRef.length;
        assert (intsRef2.length > 0);
        return new IntsRef(intsRef.ints, intsRef.offset + intsRef2.length, intsRef.length - intsRef2.length);
    }

    @Override
    public IntsRef add(IntsRef intsRef, IntsRef intsRef2) {
        assert (intsRef != null);
        assert (intsRef2 != null);
        if (intsRef == NO_OUTPUT) {
            return intsRef2;
        }
        if (intsRef2 == NO_OUTPUT) {
            return intsRef;
        }
        assert (intsRef.length > 0);
        assert (intsRef2.length > 0);
        IntsRef intsRef3 = new IntsRef(intsRef.length + intsRef2.length);
        System.arraycopy(intsRef.ints, intsRef.offset, intsRef3.ints, 0, intsRef.length);
        System.arraycopy(intsRef2.ints, intsRef2.offset, intsRef3.ints, intsRef.length, intsRef2.length);
        intsRef3.length = intsRef.length + intsRef2.length;
        return intsRef3;
    }

    @Override
    public void write(IntsRef intsRef, DataOutput dataOutput) throws IOException {
        assert (intsRef != null);
        dataOutput.writeVInt(intsRef.length);
        for (int i = 0; i < intsRef.length; ++i) {
            dataOutput.writeVInt(intsRef.ints[intsRef.offset + i]);
        }
    }

    @Override
    public IntsRef read(DataInput dataInput) throws IOException {
        int n = dataInput.readVInt();
        if (n == 0) {
            return NO_OUTPUT;
        }
        IntsRef intsRef = new IntsRef(n);
        for (int i = 0; i < n; ++i) {
            intsRef.ints[i] = dataInput.readVInt();
        }
        intsRef.length = n;
        return intsRef;
    }

    @Override
    public IntsRef getNoOutput() {
        return NO_OUTPUT;
    }

    @Override
    public String outputToString(IntsRef intsRef) {
        return intsRef.toString();
    }
}

