/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.concurrent.atomic.AtomicBoolean;

public final class SetOnce<T> {
    private volatile T obj = null;
    private final AtomicBoolean set;

    public SetOnce() {
        this.set = new AtomicBoolean(false);
    }

    public SetOnce(T t) {
        this.obj = t;
        this.set = new AtomicBoolean(true);
    }

    public final void set(T t) {
        if (!this.set.compareAndSet(false, true)) {
            throw new AlreadySetException();
        }
        this.obj = t;
    }

    public final T get() {
        return this.obj;
    }

    public static final class AlreadySetException
    extends RuntimeException {
        public AlreadySetException() {
            super("The object cannot be set twice!");
        }
    }
}

