/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.RamUsageEstimator;

public final class RecyclingByteBlockAllocator
extends ByteBlockPool.Allocator {
    private byte[][] freeByteBlocks;
    private final int maxBufferedBlocks;
    private int freeBlocks = 0;
    private final AtomicLong bytesUsed;
    public static final int DEFAULT_BUFFERED_BLOCKS = 64;

    public RecyclingByteBlockAllocator(int n, int n2, AtomicLong atomicLong) {
        super(n);
        this.freeByteBlocks = new byte[Math.min(10, n2)][];
        this.maxBufferedBlocks = n2;
        this.bytesUsed = atomicLong;
    }

    public RecyclingByteBlockAllocator(int n, int n2) {
        this(n, n2, new AtomicLong());
    }

    public RecyclingByteBlockAllocator() {
        this(32768, 64, new AtomicLong());
    }

    @Override
    public synchronized byte[] getByteBlock() {
        if (this.freeBlocks == 0) {
            this.bytesUsed.addAndGet(this.blockSize);
            return new byte[this.blockSize];
        }
        byte[] byArray = this.freeByteBlocks[--this.freeBlocks];
        this.freeByteBlocks[this.freeBlocks] = null;
        return byArray;
    }

    @Override
    public synchronized void recycleByteBlocks(byte[][] byArray, int n, int n2) {
        int n3;
        int n4 = Math.min(this.maxBufferedBlocks - this.freeBlocks, n2 - n);
        int n5 = this.freeBlocks + n4;
        if (n5 >= this.freeByteBlocks.length) {
            byte[][] byArrayArray = new byte[ArrayUtil.oversize(n5, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(this.freeByteBlocks, 0, byArrayArray, 0, this.freeBlocks);
            this.freeByteBlocks = byArrayArray;
        }
        int n6 = n + n4;
        for (n3 = n; n3 < n6; ++n3) {
            this.freeByteBlocks[this.freeBlocks++] = byArray[n3];
            byArray[n3] = null;
        }
        for (n3 = n6; n3 < n2; ++n3) {
            byArray[n3] = null;
        }
        this.bytesUsed.addAndGet(-(n2 - n6) * this.blockSize);
        assert (this.bytesUsed.get() >= 0L);
    }

    public synchronized int numBufferedBlocks() {
        return this.freeBlocks;
    }

    public long bytesUsed() {
        return this.bytesUsed.get();
    }

    public int maxBufferedBlocks() {
        return this.maxBufferedBlocks;
    }

    public synchronized int freeBlocks(int n) {
        int n2;
        int n3;
        assert (n >= 0);
        if (n > this.freeBlocks) {
            n3 = 0;
            n2 = this.freeBlocks;
        } else {
            n3 = this.freeBlocks - n;
            n2 = n;
        }
        while (this.freeBlocks > n3) {
            this.freeByteBlocks[--this.freeBlocks] = null;
        }
        this.bytesUsed.addAndGet(-n2 * this.blockSize);
        assert (this.bytesUsed.get() >= 0L);
        return n2;
    }
}

