/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSetIterator;

public class OpenBitSet
extends DocIdSet
implements Cloneable,
Serializable,
Bits {
    protected long[] bits;
    protected int wlen;
    private long numBits;

    public OpenBitSet(long l) {
        this.numBits = l;
        this.bits = new long[OpenBitSet.bits2words(l)];
        this.wlen = this.bits.length;
    }

    public OpenBitSet() {
        this(64L);
    }

    public OpenBitSet(long[] lArray, int n) {
        this.bits = lArray;
        this.wlen = n;
        this.numBits = this.wlen * 64;
    }

    @Override
    public DocIdSetIterator iterator() {
        return new OpenBitSetIterator(this.bits, this.wlen);
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public long capacity() {
        return this.bits.length << 6;
    }

    public long size() {
        return this.capacity();
    }

    @Override
    public int length() {
        return this.bits.length << 6;
    }

    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    public long[] getBits() {
        return this.bits;
    }

    public void setBits(long[] lArray) {
        this.bits = lArray;
    }

    public int getNumWords() {
        return this.wlen;
    }

    public void setNumWords(int n) {
        this.wlen = n;
    }

    @Override
    public boolean get(int n) {
        int n2 = n >> 6;
        if (n2 >= this.bits.length) {
            return false;
        }
        int n3 = n & 0x3F;
        long l = 1L << n3;
        return (this.bits[n2] & l) != 0L;
    }

    public boolean fastGet(int n) {
        assert (n >= 0 && (long)n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = 1L << n3;
        return (this.bits[n2] & l) != 0L;
    }

    public boolean get(long l) {
        int n = (int)(l >> 6);
        if (n >= this.bits.length) {
            return false;
        }
        int n2 = (int)l & 0x3F;
        long l2 = 1L << n2;
        return (this.bits[n] & l2) != 0L;
    }

    public boolean fastGet(long l) {
        assert (l >= 0L && l < this.numBits);
        int n = (int)(l >> 6);
        int n2 = (int)l & 0x3F;
        long l2 = 1L << n2;
        return (this.bits[n] & l2) != 0L;
    }

    public int getBit(int n) {
        assert (n >= 0 && (long)n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        return (int)(this.bits[n2] >>> n3) & 1;
    }

    public void set(long l) {
        int n = this.expandingWordNum(l);
        int n2 = (int)l & 0x3F;
        long l2 = 1L << n2;
        int n3 = n;
        this.bits[n3] = this.bits[n3] | l2;
    }

    public void fastSet(int n) {
        assert (n >= 0 && (long)n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = 1L << n3;
        int n4 = n2;
        this.bits[n4] = this.bits[n4] | l;
    }

    public void fastSet(long l) {
        assert (l >= 0L && l < this.numBits);
        int n = (int)(l >> 6);
        int n2 = (int)l & 0x3F;
        long l2 = 1L << n2;
        int n3 = n;
        this.bits[n3] = this.bits[n3] | l2;
    }

    public void set(long l, long l2) {
        if (l2 <= l) {
            return;
        }
        int n = (int)(l >> 6);
        int n2 = this.expandingWordNum(l2 - 1L);
        long l3 = -1L << (int)l;
        long l4 = -1L >>> (int)(-l2);
        if (n == n2) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] | l3 & l4;
            return;
        }
        int n4 = n;
        this.bits[n4] = this.bits[n4] | l3;
        Arrays.fill(this.bits, n + 1, n2, -1L);
        int n5 = n2;
        this.bits[n5] = this.bits[n5] | l4;
    }

    protected int expandingWordNum(long l) {
        int n = (int)(l >> 6);
        if (n >= this.wlen) {
            this.ensureCapacity(l + 1L);
            this.wlen = n + 1;
        }
        assert ((this.numBits = Math.max(this.numBits, l + 1L)) >= 0L);
        return n;
    }

    public void fastClear(int n) {
        assert (n >= 0 && (long)n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = 1L << n3;
        int n4 = n2;
        this.bits[n4] = this.bits[n4] & (l ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void fastClear(long l) {
        assert (l >= 0L && l < this.numBits);
        int n = (int)(l >> 6);
        int n2 = (int)l & 0x3F;
        long l2 = 1L << n2;
        int n3 = n;
        this.bits[n3] = this.bits[n3] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(long l) {
        int n = (int)(l >> 6);
        if (n >= this.wlen) {
            return;
        }
        int n2 = (int)l & 0x3F;
        long l2 = 1L << n2;
        int n3 = n;
        this.bits[n3] = this.bits[n3] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(int n, int n2) {
        if (n2 <= n) {
            return;
        }
        int n3 = n >> 6;
        if (n3 >= this.wlen) {
            return;
        }
        int n4 = n2 - 1 >> 6;
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        l ^= 0xFFFFFFFFFFFFFFFFL;
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        if (n3 == n4) {
            int n5 = n3;
            this.bits[n5] = this.bits[n5] & (l | l2);
            return;
        }
        int n6 = n3;
        this.bits[n6] = this.bits[n6] & l;
        int n7 = Math.min(this.wlen, n4);
        Arrays.fill(this.bits, n3 + 1, n7, 0L);
        if (n4 < this.wlen) {
            int n8 = n4;
            this.bits[n8] = this.bits[n8] & l2;
        }
    }

    public void clear(long l, long l2) {
        if (l2 <= l) {
            return;
        }
        int n = (int)(l >> 6);
        if (n >= this.wlen) {
            return;
        }
        int n2 = (int)(l2 - 1L >> 6);
        long l3 = -1L << (int)l;
        long l4 = -1L >>> (int)(-l2);
        l3 ^= 0xFFFFFFFFFFFFFFFFL;
        l4 ^= 0xFFFFFFFFFFFFFFFFL;
        if (n == n2) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] & (l3 | l4);
            return;
        }
        int n4 = n;
        this.bits[n4] = this.bits[n4] & l3;
        int n5 = Math.min(this.wlen, n2);
        Arrays.fill(this.bits, n + 1, n5, 0L);
        if (n2 < this.wlen) {
            int n6 = n2;
            this.bits[n6] = this.bits[n6] & l4;
        }
    }

    public boolean getAndSet(int n) {
        assert (n >= 0 && (long)n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = 1L << n3;
        boolean bl = (this.bits[n2] & l) != 0L;
        int n4 = n2;
        this.bits[n4] = this.bits[n4] | l;
        return bl;
    }

    public boolean getAndSet(long l) {
        assert (l >= 0L && l < this.numBits);
        int n = (int)(l >> 6);
        int n2 = (int)l & 0x3F;
        long l2 = 1L << n2;
        boolean bl = (this.bits[n] & l2) != 0L;
        int n3 = n;
        this.bits[n3] = this.bits[n3] | l2;
        return bl;
    }

    public void fastFlip(int n) {
        assert (n >= 0 && (long)n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = 1L << n3;
        int n4 = n2;
        this.bits[n4] = this.bits[n4] ^ l;
    }

    public void fastFlip(long l) {
        assert (l >= 0L && l < this.numBits);
        int n = (int)(l >> 6);
        int n2 = (int)l & 0x3F;
        long l2 = 1L << n2;
        int n3 = n;
        this.bits[n3] = this.bits[n3] ^ l2;
    }

    public void flip(long l) {
        int n = this.expandingWordNum(l);
        int n2 = (int)l & 0x3F;
        long l2 = 1L << n2;
        int n3 = n;
        this.bits[n3] = this.bits[n3] ^ l2;
    }

    public boolean flipAndGet(int n) {
        assert (n >= 0 && (long)n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = 1L << n3;
        int n4 = n2;
        this.bits[n4] = this.bits[n4] ^ l;
        return (this.bits[n2] & l) != 0L;
    }

    public boolean flipAndGet(long l) {
        assert (l >= 0L && l < this.numBits);
        int n = (int)(l >> 6);
        int n2 = (int)l & 0x3F;
        long l2 = 1L << n2;
        int n3 = n;
        this.bits[n3] = this.bits[n3] ^ l2;
        return (this.bits[n] & l2) != 0L;
    }

    public void flip(long l, long l2) {
        if (l2 <= l) {
            return;
        }
        int n = (int)(l >> 6);
        int n2 = this.expandingWordNum(l2 - 1L);
        long l3 = -1L << (int)l;
        long l4 = -1L >>> (int)(-l2);
        if (n == n2) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] ^ l3 & l4;
            return;
        }
        int n4 = n;
        this.bits[n4] = this.bits[n4] ^ l3;
        for (int i = n + 1; i < n2; ++i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n5 = n2;
        this.bits[n5] = this.bits[n5] ^ l4;
    }

    public long cardinality() {
        return BitUtil.pop_array(this.bits, 0, this.wlen);
    }

    public static long intersectionCount(OpenBitSet openBitSet, OpenBitSet openBitSet2) {
        return BitUtil.pop_intersect(openBitSet.bits, openBitSet2.bits, 0, Math.min(openBitSet.wlen, openBitSet2.wlen));
    }

    public static long unionCount(OpenBitSet openBitSet, OpenBitSet openBitSet2) {
        long l = BitUtil.pop_union(openBitSet.bits, openBitSet2.bits, 0, Math.min(openBitSet.wlen, openBitSet2.wlen));
        if (openBitSet.wlen < openBitSet2.wlen) {
            l += BitUtil.pop_array(openBitSet2.bits, openBitSet.wlen, openBitSet2.wlen - openBitSet.wlen);
        } else if (openBitSet.wlen > openBitSet2.wlen) {
            l += BitUtil.pop_array(openBitSet.bits, openBitSet2.wlen, openBitSet.wlen - openBitSet2.wlen);
        }
        return l;
    }

    public static long andNotCount(OpenBitSet openBitSet, OpenBitSet openBitSet2) {
        long l = BitUtil.pop_andnot(openBitSet.bits, openBitSet2.bits, 0, Math.min(openBitSet.wlen, openBitSet2.wlen));
        if (openBitSet.wlen > openBitSet2.wlen) {
            l += BitUtil.pop_array(openBitSet.bits, openBitSet2.wlen, openBitSet.wlen - openBitSet2.wlen);
        }
        return l;
    }

    public static long xorCount(OpenBitSet openBitSet, OpenBitSet openBitSet2) {
        long l = BitUtil.pop_xor(openBitSet.bits, openBitSet2.bits, 0, Math.min(openBitSet.wlen, openBitSet2.wlen));
        if (openBitSet.wlen < openBitSet2.wlen) {
            l += BitUtil.pop_array(openBitSet2.bits, openBitSet.wlen, openBitSet2.wlen - openBitSet.wlen);
        } else if (openBitSet.wlen > openBitSet2.wlen) {
            l += BitUtil.pop_array(openBitSet.bits, openBitSet2.wlen, openBitSet.wlen - openBitSet2.wlen);
        }
        return l;
    }

    public int nextSetBit(int n) {
        int n2 = n >> 6;
        if (n2 >= this.wlen) {
            return -1;
        }
        int n3 = n & 0x3F;
        long l = this.bits[n2] >> n3;
        if (l != 0L) {
            return (n2 << 6) + n3 + BitUtil.ntz(l);
        }
        while (++n2 < this.wlen) {
            l = this.bits[n2];
            if (l == 0L) continue;
            return (n2 << 6) + BitUtil.ntz(l);
        }
        return -1;
    }

    public long nextSetBit(long l) {
        int n = (int)(l >>> 6);
        if (n >= this.wlen) {
            return -1L;
        }
        int n2 = (int)l & 0x3F;
        long l2 = this.bits[n] >>> n2;
        if (l2 != 0L) {
            return ((long)n << 6) + (long)(n2 + BitUtil.ntz(l2));
        }
        while (++n < this.wlen) {
            l2 = this.bits[n];
            if (l2 == 0L) continue;
            return ((long)n << 6) + (long)BitUtil.ntz(l2);
        }
        return -1L;
    }

    public int prevSetBit(int n) {
        long l;
        int n2;
        int n3 = n >> 6;
        if (n3 >= this.wlen) {
            n3 = this.wlen - 1;
            if (n3 < 0) {
                return -1;
            }
            n2 = 63;
            l = this.bits[n3];
        } else {
            if (n3 < 0) {
                return -1;
            }
            n2 = n & 0x3F;
            l = this.bits[n3] << 63 - n2;
        }
        if (l != 0L) {
            return (n3 << 6) + n2 - Long.numberOfLeadingZeros(l);
        }
        while (--n3 >= 0) {
            l = this.bits[n3];
            if (l == 0L) continue;
            return (n3 << 6) + 63 - Long.numberOfLeadingZeros(l);
        }
        return -1;
    }

    public long prevSetBit(long l) {
        long l2;
        int n;
        int n2 = (int)(l >> 6);
        if (n2 >= this.wlen) {
            n2 = this.wlen - 1;
            if (n2 < 0) {
                return -1L;
            }
            n = 63;
            l2 = this.bits[n2];
        } else {
            if (n2 < 0) {
                return -1L;
            }
            n = (int)l & 0x3F;
            l2 = this.bits[n2] << 63 - n;
        }
        if (l2 != 0L) {
            return ((long)n2 << 6) + (long)n - (long)Long.numberOfLeadingZeros(l2);
        }
        while (--n2 >= 0) {
            l2 = this.bits[n2];
            if (l2 == 0L) continue;
            return ((long)n2 << 6) + 63L - (long)Long.numberOfLeadingZeros(l2);
        }
        return -1L;
    }

    public Object clone() {
        try {
            OpenBitSet openBitSet = (OpenBitSet)super.clone();
            openBitSet.bits = (long[])openBitSet.bits.clone();
            return openBitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public void intersect(OpenBitSet openBitSet) {
        int n = Math.min(this.wlen, openBitSet.wlen);
        long[] lArray = this.bits;
        long[] lArray2 = openBitSet.bits;
        int n2 = n;
        while (--n2 >= 0) {
            int n3 = n2;
            lArray[n3] = lArray[n3] & lArray2[n2];
        }
        if (this.wlen > n) {
            Arrays.fill(this.bits, n, this.wlen, 0L);
        }
        this.wlen = n;
    }

    public void union(OpenBitSet openBitSet) {
        int n = Math.max(this.wlen, openBitSet.wlen);
        this.ensureCapacityWords(n);
        assert ((this.numBits = Math.max(openBitSet.numBits, this.numBits)) >= 0L);
        long[] lArray = this.bits;
        long[] lArray2 = openBitSet.bits;
        int n2 = Math.min(this.wlen, openBitSet.wlen);
        while (--n2 >= 0) {
            int n3 = n2;
            lArray[n3] = lArray[n3] | lArray2[n2];
        }
        if (this.wlen < n) {
            System.arraycopy(lArray2, this.wlen, lArray, this.wlen, n - this.wlen);
        }
        this.wlen = n;
    }

    public void remove(OpenBitSet openBitSet) {
        int n = Math.min(this.wlen, openBitSet.wlen);
        long[] lArray = this.bits;
        long[] lArray2 = openBitSet.bits;
        while (--n >= 0) {
            int n2 = n;
            lArray[n2] = lArray[n2] & (lArray2[n] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void xor(OpenBitSet openBitSet) {
        int n = Math.max(this.wlen, openBitSet.wlen);
        this.ensureCapacityWords(n);
        assert ((this.numBits = Math.max(openBitSet.numBits, this.numBits)) >= 0L);
        long[] lArray = this.bits;
        long[] lArray2 = openBitSet.bits;
        int n2 = Math.min(this.wlen, openBitSet.wlen);
        while (--n2 >= 0) {
            int n3 = n2;
            lArray[n3] = lArray[n3] ^ lArray2[n2];
        }
        if (this.wlen < n) {
            System.arraycopy(lArray2, this.wlen, lArray, this.wlen, n - this.wlen);
        }
        this.wlen = n;
    }

    public void and(OpenBitSet openBitSet) {
        this.intersect(openBitSet);
    }

    public void or(OpenBitSet openBitSet) {
        this.union(openBitSet);
    }

    public void andNot(OpenBitSet openBitSet) {
        this.remove(openBitSet);
    }

    public boolean intersects(OpenBitSet openBitSet) {
        int n = Math.min(this.wlen, openBitSet.wlen);
        long[] lArray = this.bits;
        long[] lArray2 = openBitSet.bits;
        while (--n >= 0) {
            if ((lArray[n] & lArray2[n]) == 0L) continue;
            return true;
        }
        return false;
    }

    public void ensureCapacityWords(int n) {
        if (this.bits.length < n) {
            this.bits = ArrayUtil.grow(this.bits, n);
        }
    }

    public void ensureCapacity(long l) {
        this.ensureCapacityWords(OpenBitSet.bits2words(l));
    }

    public void trimTrailingZeros() {
        int n;
        for (n = this.wlen - 1; n >= 0 && this.bits[n] == 0L; --n) {
        }
        this.wlen = n + 1;
    }

    public static int bits2words(long l) {
        return (int)((l - 1L >>> 6) + 1L);
    }

    public boolean equals(Object object) {
        int n;
        OpenBitSet openBitSet;
        if (this == object) {
            return true;
        }
        if (!(object instanceof OpenBitSet)) {
            return false;
        }
        OpenBitSet openBitSet2 = (OpenBitSet)object;
        if (openBitSet2.wlen > this.wlen) {
            openBitSet = openBitSet2;
            openBitSet2 = this;
        } else {
            openBitSet = this;
        }
        for (n = openBitSet.wlen - 1; n >= openBitSet2.wlen; --n) {
            if (openBitSet.bits[n] == 0L) continue;
            return false;
        }
        for (n = openBitSet2.wlen - 1; n >= 0; --n) {
            if (openBitSet.bits[n] == openBitSet2.bits[n]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long l = 0L;
        int n = this.bits.length;
        while (--n >= 0) {
            l ^= this.bits[n];
            l = l << 1 | l >>> 63;
        }
        return (int)(l >> 32 ^ l) + -1737092556;
    }
}

