/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public final class English {
    private English() {
    }

    public static String longToEnglish(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        English.longToEnglish(l, stringBuilder);
        return stringBuilder.toString();
    }

    public static void longToEnglish(long l, StringBuilder stringBuilder) {
        if (l == 0L) {
            stringBuilder.append("zero");
            return;
        }
        if (l < 0L) {
            stringBuilder.append("minus ");
            l = -l;
        }
        if (l >= 1000000000000000000L) {
            English.longToEnglish(l / 1000000000000000000L, stringBuilder);
            stringBuilder.append("quintillion, ");
            l %= 1000000000000000000L;
        }
        if (l >= 1000000000000000L) {
            English.longToEnglish(l / 1000000000000000L, stringBuilder);
            stringBuilder.append("quadrillion, ");
            l %= 1000000000000000L;
        }
        if (l >= 1000000000000L) {
            English.longToEnglish(l / 1000000000000L, stringBuilder);
            stringBuilder.append("trillion, ");
            l %= 1000000000000L;
        }
        if (l >= 1000000000L) {
            English.longToEnglish(l / 1000000000L, stringBuilder);
            stringBuilder.append("billion, ");
            l %= 1000000000L;
        }
        if (l >= 1000000L) {
            English.longToEnglish(l / 1000000L, stringBuilder);
            stringBuilder.append("million, ");
            l %= 1000000L;
        }
        if (l >= 1000L) {
            English.longToEnglish(l / 1000L, stringBuilder);
            stringBuilder.append("thousand, ");
            l %= 1000L;
        }
        if (l >= 100L) {
            English.longToEnglish(l / 100L, stringBuilder);
            stringBuilder.append("hundred ");
            l %= 100L;
        }
        if (l >= 20L) {
            switch ((int)l / 10) {
                case 9: {
                    stringBuilder.append("ninety");
                    break;
                }
                case 8: {
                    stringBuilder.append("eighty");
                    break;
                }
                case 7: {
                    stringBuilder.append("seventy");
                    break;
                }
                case 6: {
                    stringBuilder.append("sixty");
                    break;
                }
                case 5: {
                    stringBuilder.append("fifty");
                    break;
                }
                case 4: {
                    stringBuilder.append("forty");
                    break;
                }
                case 3: {
                    stringBuilder.append("thirty");
                    break;
                }
                case 2: {
                    stringBuilder.append("twenty");
                }
            }
            if ((l %= 10L) == 0L) {
                stringBuilder.append(" ");
            } else {
                stringBuilder.append("-");
            }
        }
        switch ((int)l) {
            case 19: {
                stringBuilder.append("nineteen ");
                break;
            }
            case 18: {
                stringBuilder.append("eighteen ");
                break;
            }
            case 17: {
                stringBuilder.append("seventeen ");
                break;
            }
            case 16: {
                stringBuilder.append("sixteen ");
                break;
            }
            case 15: {
                stringBuilder.append("fifteen ");
                break;
            }
            case 14: {
                stringBuilder.append("fourteen ");
                break;
            }
            case 13: {
                stringBuilder.append("thirteen ");
                break;
            }
            case 12: {
                stringBuilder.append("twelve ");
                break;
            }
            case 11: {
                stringBuilder.append("eleven ");
                break;
            }
            case 10: {
                stringBuilder.append("ten ");
                break;
            }
            case 9: {
                stringBuilder.append("nine ");
                break;
            }
            case 8: {
                stringBuilder.append("eight ");
                break;
            }
            case 7: {
                stringBuilder.append("seven ");
                break;
            }
            case 6: {
                stringBuilder.append("six ");
                break;
            }
            case 5: {
                stringBuilder.append("five ");
                break;
            }
            case 4: {
                stringBuilder.append("four ");
                break;
            }
            case 3: {
                stringBuilder.append("three ");
                break;
            }
            case 2: {
                stringBuilder.append("two ");
                break;
            }
            case 1: {
                stringBuilder.append("one ");
                break;
            }
            case 0: {
                stringBuilder.append("");
            }
        }
    }

    public static String intToEnglish(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        English.longToEnglish(n, stringBuilder);
        return stringBuilder.toString();
    }

    public static void intToEnglish(int n, StringBuilder stringBuilder) {
        English.longToEnglish(n, stringBuilder);
    }

    public static void main(String[] stringArray) {
        System.out.println(English.longToEnglish(Long.parseLong(stringArray[0])));
    }
}

