/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.BitSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class DocIdBitSet
extends DocIdSet {
    private BitSet bitSet;

    public DocIdBitSet(BitSet bitSet) {
        this.bitSet = bitSet;
    }

    @Override
    public DocIdSetIterator iterator() {
        return new DocIdBitSetIterator(this.bitSet);
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    private static class DocIdBitSetIterator
    extends DocIdSetIterator {
        private int docId;
        private BitSet bitSet;

        DocIdBitSetIterator(BitSet bitSet) {
            this.bitSet = bitSet;
            this.docId = -1;
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public int nextDoc() {
            int n = this.bitSet.nextSetBit(this.docId + 1);
            this.docId = n == -1 ? Integer.MAX_VALUE : n;
            return this.docId;
        }

        @Override
        public int advance(int n) {
            int n2 = this.bitSet.nextSetBit(n);
            this.docId = n2 == -1 ? Integer.MAX_VALUE : n2;
            return this.docId;
        }
    }
}

