/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.CodecUtil;

public final class BitVector
implements Cloneable,
Bits {
    private byte[] bits;
    private int size;
    private int count;
    private static final byte[] BYTE_COUNTS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static String CODEC = "BitVector";
    private static final int VERSION_PRE = -1;
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;

    public BitVector(int n) {
        this.size = n;
        this.bits = new byte[this.getNumBytes(this.size)];
        this.count = 0;
    }

    BitVector(byte[] byArray, int n) {
        this.bits = byArray;
        this.size = n;
        this.count = -1;
    }

    private int getNumBytes(int n) {
        int n2 = n >>> 3;
        if ((n & 7) != 0) {
            ++n2;
        }
        return n2;
    }

    public Object clone() {
        byte[] byArray = new byte[this.bits.length];
        System.arraycopy(this.bits, 0, byArray, 0, this.bits.length);
        BitVector bitVector = new BitVector(byArray, this.size);
        bitVector.count = this.count;
        return bitVector;
    }

    public final void set(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("bit=" + n + " size=" + this.size);
        }
        int n2 = n >> 3;
        this.bits[n2] = (byte)(this.bits[n2] | 1 << (n & 7));
        this.count = -1;
    }

    public final boolean getAndSet(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("bit=" + n + " size=" + this.size);
        }
        int n2 = 1 << (n & 7);
        int n3 = n >> 3;
        byte by = this.bits[n3];
        if ((n2 & by) != 0) {
            return true;
        }
        this.bits[n3] = (byte)(by | n2);
        if (this.count != -1) {
            ++this.count;
        }
        return false;
    }

    public final void clear(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = n >> 3;
        this.bits[n2] = (byte)(this.bits[n2] & ~(1 << (n & 7)));
        this.count = -1;
    }

    @Override
    public final boolean get(int n) {
        assert (n >= 0 && n < this.size) : "bit " + n + " is out of bounds 0.." + (this.size - 1);
        return (this.bits[n >> 3] & 1 << (n & 7)) != 0;
    }

    public final int size() {
        return this.size;
    }

    @Override
    public final int length() {
        return this.size;
    }

    public final int count() {
        if (this.count == -1) {
            int n = 0;
            int n2 = this.bits.length;
            for (int i = 0; i < n2; ++i) {
                n += BYTE_COUNTS[this.bits[i] & 0xFF];
            }
            this.count = n;
        }
        return this.count;
    }

    public final int getRecomputedCount() {
        int n = 0;
        int n2 = this.bits.length;
        for (int i = 0; i < n2; ++i) {
            n += BYTE_COUNTS[this.bits[i] & 0xFF];
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Directory directory, String string) throws IOException {
        IndexOutput indexOutput = directory.createOutput(string);
        try {
            indexOutput.writeInt(-2);
            CodecUtil.writeHeader(indexOutput, CODEC, 0);
            if (this.isSparse()) {
                this.writeDgaps(indexOutput);
            } else {
                this.writeBits(indexOutput);
            }
        }
        finally {
            indexOutput.close();
        }
    }

    private void writeBits(IndexOutput indexOutput) throws IOException {
        indexOutput.writeInt(this.size());
        indexOutput.writeInt(this.count());
        indexOutput.writeBytes(this.bits, this.bits.length);
    }

    private void writeDgaps(IndexOutput indexOutput) throws IOException {
        indexOutput.writeInt(-1);
        indexOutput.writeInt(this.size());
        indexOutput.writeInt(this.count());
        int n = 0;
        int n2 = this.count();
        int n3 = this.bits.length;
        for (int i = 0; i < n3 && n2 > 0; ++i) {
            if (this.bits[i] == 0) continue;
            indexOutput.writeVInt(i - n);
            indexOutput.writeByte(this.bits[i]);
            n = i;
            n2 -= BYTE_COUNTS[this.bits[i] & 0xFF];
        }
    }

    private boolean isSparse() {
        int n = this.count();
        if (n == 0) {
            return true;
        }
        int n2 = this.bits.length / n;
        int n3 = n2 <= 128 ? 1 : (n2 <= 16384 ? 2 : (n2 <= 0x200000 ? 3 : (n2 <= 0x10000000 ? 4 : 5)));
        int n4 = n3 + 1;
        long l = 32 + 8 * n4 * this.count();
        return 10L * l < (long)this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitVector(Directory directory, String string) throws IOException {
        IndexInput indexInput = directory.openInput(string);
        try {
            int n = indexInput.readInt();
            if (n == -2) {
                int n2 = CodecUtil.checkHeader(indexInput, CODEC, 0, 0);
                this.size = indexInput.readInt();
            } else {
                int n3 = -1;
                this.size = n;
            }
            if (this.size == -1) {
                this.readDgaps(indexInput);
            } else {
                this.readBits(indexInput);
            }
        }
        finally {
            indexInput.close();
        }
    }

    private void readBits(IndexInput indexInput) throws IOException {
        this.count = indexInput.readInt();
        this.bits = new byte[this.getNumBytes(this.size)];
        indexInput.readBytes(this.bits, 0, this.bits.length);
    }

    private void readDgaps(IndexInput indexInput) throws IOException {
        this.size = indexInput.readInt();
        this.count = indexInput.readInt();
        this.bits = new byte[(this.size >> 3) + 1];
        int n = 0;
        for (int i = this.count(); i > 0; i -= BYTE_COUNTS[this.bits[n] & 0xFF]) {
            this.bits[n += indexInput.readVInt()] = indexInput.readByte();
        }
    }
}

