/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;

public class VerifyingLockFactory
extends LockFactory {
    LockFactory lf;
    byte id;
    String host;
    int port;

    public VerifyingLockFactory(byte by, LockFactory lockFactory, String string, int n) throws IOException {
        this.id = by;
        this.lf = lockFactory;
        this.host = string;
        this.port = n;
    }

    @Override
    public synchronized Lock makeLock(String string) {
        return new CheckedLock(this.lf.makeLock(string));
    }

    @Override
    public synchronized void clearLock(String string) throws IOException {
        this.lf.clearLock(string);
    }

    private class CheckedLock
    extends Lock {
        private Lock lock;

        public CheckedLock(Lock lock) {
            this.lock = lock;
        }

        private void verify(byte by) {
            try {
                Socket socket = new Socket(VerifyingLockFactory.this.host, VerifyingLockFactory.this.port);
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(VerifyingLockFactory.this.id);
                outputStream.write(by);
                InputStream inputStream = socket.getInputStream();
                int n = inputStream.read();
                inputStream.close();
                outputStream.close();
                socket.close();
                if (n != 0) {
                    throw new RuntimeException("lock was double acquired");
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public synchronized boolean obtain(long l) throws LockObtainFailedException, IOException {
            boolean bl = this.lock.obtain(l);
            if (bl) {
                this.verify((byte)1);
            }
            return bl;
        }

        @Override
        public synchronized boolean obtain() throws LockObtainFailedException, IOException {
            return this.lock.obtain();
        }

        @Override
        public synchronized boolean isLocked() throws IOException {
            return this.lock.isLocked();
        }

        @Override
        public synchronized void release() throws IOException {
            if (this.isLocked()) {
                this.verify((byte)0);
                this.lock.release();
            }
        }
    }
}

