/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.SimpleFSLock;

public class SimpleFSLockFactory
extends FSLockFactory {
    public SimpleFSLockFactory() throws IOException {
        this((File)null);
    }

    public SimpleFSLockFactory(File file) throws IOException {
        this.setLockDir(file);
    }

    public SimpleFSLockFactory(String string) throws IOException {
        this.setLockDir(new File(string));
    }

    @Override
    public Lock makeLock(String string) {
        if (this.lockPrefix != null) {
            string = this.lockPrefix + "-" + string;
        }
        return new SimpleFSLock(this.lockDir, string);
    }

    @Override
    public void clearLock(String string) throws IOException {
        if (this.lockDir.exists()) {
            File file;
            if (this.lockPrefix != null) {
                string = this.lockPrefix + "-" + string;
            }
            if ((file = new File(this.lockDir, string)).exists() && !file.delete()) {
                throw new IOException("Cannot delete " + file);
            }
        }
    }
}

