/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.util.ThreadInterruptedException;

public class RAMDirectory
extends Directory
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, RAMFile> fileMap = new ConcurrentHashMap<String, RAMFile>();
    protected final AtomicLong sizeInBytes = new AtomicLong();

    public RAMDirectory() {
        try {
            this.setLockFactory(new SingleInstanceLockFactory());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public RAMDirectory(Directory directory) throws IOException {
        this(directory, false);
    }

    private RAMDirectory(Directory directory, boolean bl) throws IOException {
        this();
        IndexFileNameFilter indexFileNameFilter = IndexFileNameFilter.getFilter();
        for (String string : directory.listAll()) {
            if (!indexFileNameFilter.accept(null, string)) continue;
            directory.copy(this, string, string);
        }
        if (bl) {
            directory.close();
        }
    }

    @Override
    public final String[] listAll() {
        this.ensureOpen();
        Set<String> set = this.fileMap.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        for (String string : set) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public final boolean fileExists(String string) {
        this.ensureOpen();
        return this.fileMap.containsKey(string);
    }

    @Override
    public final long fileModified(String string) throws IOException {
        this.ensureOpen();
        RAMFile rAMFile = this.fileMap.get(string);
        if (rAMFile == null) {
            throw new FileNotFoundException(string);
        }
        return rAMFile.getLastModified();
    }

    @Override
    @Deprecated
    public void touchFile(String string) throws IOException {
        long l;
        this.ensureOpen();
        RAMFile rAMFile = this.fileMap.get(string);
        if (rAMFile == null) {
            throw new FileNotFoundException(string);
        }
        long l2 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                throw new ThreadInterruptedException(interruptedException);
            }
        } while (l2 == (l = System.currentTimeMillis()));
        rAMFile.setLastModified(l);
    }

    @Override
    public final long fileLength(String string) throws IOException {
        this.ensureOpen();
        RAMFile rAMFile = this.fileMap.get(string);
        if (rAMFile == null) {
            throw new FileNotFoundException(string);
        }
        return rAMFile.getLength();
    }

    public final long sizeInBytes() {
        this.ensureOpen();
        return this.sizeInBytes.get();
    }

    @Override
    public void deleteFile(String string) throws IOException {
        this.ensureOpen();
        RAMFile rAMFile = this.fileMap.remove(string);
        if (rAMFile == null) {
            throw new FileNotFoundException(string);
        }
        rAMFile.directory = null;
        this.sizeInBytes.addAndGet(-rAMFile.sizeInBytes);
    }

    @Override
    public IndexOutput createOutput(String string) throws IOException {
        this.ensureOpen();
        RAMFile rAMFile = this.newRAMFile();
        RAMFile rAMFile2 = this.fileMap.remove(string);
        if (rAMFile2 != null) {
            this.sizeInBytes.addAndGet(-rAMFile2.sizeInBytes);
            rAMFile2.directory = null;
        }
        this.fileMap.put(string, rAMFile);
        return new RAMOutputStream(rAMFile);
    }

    protected RAMFile newRAMFile() {
        return new RAMFile(this);
    }

    @Override
    public IndexInput openInput(String string) throws IOException {
        this.ensureOpen();
        RAMFile rAMFile = this.fileMap.get(string);
        if (rAMFile == null) {
            throw new FileNotFoundException(string);
        }
        return new RAMInputStream(string, rAMFile);
    }

    @Override
    public void close() {
        this.isOpen = false;
        this.fileMap.clear();
    }
}

