/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.VerifyingLockFactory;

public class LockStressTest {
    public static void main(String[] stringArray) throws Exception {
        LockFactory lockFactory;
        int n;
        if (stringArray.length != 6) {
            System.out.println("\nUsage: java org.apache.lucene.store.LockStressTest myID verifierHostOrIP verifierPort lockFactoryClassName lockDirName sleepTime\n\n  myID = int from 0 .. 255 (should be unique for test process)\n  verifierHostOrIP = host name or IP address where LockVerifyServer is running\n  verifierPort = port that LockVerifyServer is listening on\n  lockFactoryClassName = primary LockFactory class that we will use\n  lockDirName = path to the lock directory (only set for Simple/NativeFSLockFactory\n  sleepTimeMS = milliseconds to pause betweeen each lock obtain/release\n\nYou should run multiple instances of this process, each with its own\nunique ID, and each pointing to the same lock directory, to verify\nthat locking is working correctly.\n\nMake sure you are first running LockVerifyServer.\n\n");
            System.exit(1);
        }
        if ((n = Integer.parseInt(stringArray[0])) < 0 || n > 255) {
            System.out.println("myID must be a unique int 0..255");
            System.exit(1);
        }
        String string = stringArray[1];
        int n2 = Integer.parseInt(stringArray[2]);
        String string2 = stringArray[3];
        String string3 = stringArray[4];
        int n3 = Integer.parseInt(stringArray[5]);
        try {
            lockFactory = Class.forName(string2).asSubclass(LockFactory.class).newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("IllegalAccessException when instantiating LockClass " + string2);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("InstantiationException when instantiating LockClass " + string2);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("unable to cast LockClass " + string2 + " instance to a LockFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("unable to find LockClass " + string2);
        }
        File file = new File(string3);
        if (lockFactory instanceof FSLockFactory) {
            ((FSLockFactory)lockFactory).setLockDir(file);
        }
        lockFactory.setLockPrefix("test");
        VerifyingLockFactory verifyingLockFactory = new VerifyingLockFactory((byte)n, lockFactory, string, n2);
        Lock lock = ((LockFactory)verifyingLockFactory).makeLock("test.lock");
        while (true) {
            boolean bl = false;
            try {
                bl = lock.obtain(10L);
            }
            catch (LockObtainFailedException lockObtainFailedException) {
                System.out.print("x");
            }
            if (bl) {
                System.out.print("l");
                lock.release();
            }
            Thread.sleep(n3);
        }
    }
}

