/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.ThreadInterruptedException;

public abstract class Lock {
    public static long LOCK_POLL_INTERVAL = 1000L;
    public static final long LOCK_OBTAIN_WAIT_FOREVER = -1L;
    protected Throwable failureReason;

    public abstract boolean obtain() throws IOException;

    public boolean obtain(long l) throws LockObtainFailedException, IOException {
        this.failureReason = null;
        boolean bl = this.obtain();
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("lockWaitTimeout should be LOCK_OBTAIN_WAIT_FOREVER or a non-negative number (got " + l + ")");
        }
        long l2 = l / LOCK_POLL_INTERVAL;
        long l3 = 0L;
        while (!bl) {
            if (l != -1L && l3++ >= l2) {
                String string = "Lock obtain timed out: " + this.toString();
                if (this.failureReason != null) {
                    string = string + ": " + this.failureReason;
                }
                LockObtainFailedException lockObtainFailedException = new LockObtainFailedException(string);
                if (this.failureReason != null) {
                    lockObtainFailedException.initCause(this.failureReason);
                }
                throw lockObtainFailedException;
            }
            try {
                Thread.sleep(LOCK_POLL_INTERVAL);
            }
            catch (InterruptedException interruptedException) {
                throw new ThreadInterruptedException(interruptedException);
            }
            bl = this.obtain();
        }
        return bl;
    }

    public abstract void release() throws IOException;

    public abstract boolean isLocked() throws IOException;

    public static abstract class With {
        private Lock lock;
        private long lockWaitTimeout;

        public With(Lock lock, long l) {
            this.lock = lock;
            this.lockWaitTimeout = l;
        }

        protected abstract Object doBody() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws LockObtainFailedException, IOException {
            boolean bl = false;
            try {
                bl = this.lock.obtain(this.lockWaitTimeout);
                Object object = this.doBody();
                return object;
            }
            finally {
                if (bl) {
                    this.lock.release();
                }
            }
        }
    }
}

