/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.IOUtils;

public abstract class Directory
implements Closeable {
    protected volatile boolean isOpen = true;
    protected LockFactory lockFactory;

    public abstract String[] listAll() throws IOException;

    public abstract boolean fileExists(String var1) throws IOException;

    public abstract long fileModified(String var1) throws IOException;

    @Deprecated
    public abstract void touchFile(String var1) throws IOException;

    public abstract void deleteFile(String var1) throws IOException;

    public abstract long fileLength(String var1) throws IOException;

    public abstract IndexOutput createOutput(String var1) throws IOException;

    @Deprecated
    public void sync(String string) throws IOException {
    }

    public void sync(Collection<String> collection) throws IOException {
        for (String string : collection) {
            this.sync(string);
        }
    }

    public abstract IndexInput openInput(String var1) throws IOException;

    public IndexInput openInput(String string, int n) throws IOException {
        return this.openInput(string);
    }

    public Lock makeLock(String string) {
        return this.lockFactory.makeLock(string);
    }

    public void clearLock(String string) throws IOException {
        if (this.lockFactory != null) {
            this.lockFactory.clearLock(string);
        }
    }

    @Override
    public abstract void close() throws IOException;

    public void setLockFactory(LockFactory lockFactory) throws IOException {
        assert (lockFactory != null);
        this.lockFactory = lockFactory;
        lockFactory.setLockPrefix(this.getLockID());
    }

    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    public String getLockID() {
        return this.toString();
    }

    public String toString() {
        return super.toString() + " lockFactory=" + this.getLockFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(Directory directory, String string, String string2) throws IOException {
        IndexOutput indexOutput = null;
        IndexInput indexInput = null;
        IOException iOException = null;
        try {
            indexOutput = directory.createOutput(string2);
            indexInput = this.openInput(string);
            indexInput.copyBytes(indexOutput, indexInput.length());
        }
        catch (IOException iOException2) {
            try {
                iOException = iOException2;
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(iOException, indexOutput, indexInput);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(iOException, indexOutput, indexInput);
        }
        IOUtils.closeWhileHandlingException(iOException, indexOutput, indexInput);
    }

    @Deprecated
    public static void copy(Directory directory, Directory directory2, boolean bl) throws IOException {
        IndexFileNameFilter indexFileNameFilter = IndexFileNameFilter.getFilter();
        for (String string : directory.listAll()) {
            if (!indexFileNameFilter.accept(null, string)) continue;
            directory.copy(directory2, string, string);
        }
        if (bl) {
            directory.close();
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }
}

