/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanNotQuery
extends SpanQuery
implements Cloneable {
    private SpanQuery include;
    private SpanQuery exclude;

    public SpanNotQuery(SpanQuery spanQuery, SpanQuery spanQuery2) {
        this.include = spanQuery;
        this.exclude = spanQuery2;
        if (!spanQuery.getField().equals(spanQuery2.getField())) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
    }

    public SpanQuery getInclude() {
        return this.include;
    }

    public SpanQuery getExclude() {
        return this.exclude;
    }

    @Override
    public String getField() {
        return this.include.getField();
    }

    @Override
    public void extractTerms(Set<Term> set) {
        this.include.extractTerms(set);
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("spanNot(");
        stringBuilder.append(this.include.toString(string));
        stringBuilder.append(", ");
        stringBuilder.append(this.exclude.toString(string));
        stringBuilder.append(")");
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public Object clone() {
        SpanNotQuery spanNotQuery = new SpanNotQuery((SpanQuery)this.include.clone(), (SpanQuery)this.exclude.clone());
        spanNotQuery.setBoost(this.getBoost());
        return spanNotQuery;
    }

    @Override
    public Spans getSpans(final IndexReader indexReader) throws IOException {
        return new Spans(){
            private Spans includeSpans;
            private boolean moreInclude;
            private Spans excludeSpans;
            private boolean moreExclude;
            {
                this.includeSpans = SpanNotQuery.this.include.getSpans(indexReader);
                this.moreInclude = true;
                this.excludeSpans = SpanNotQuery.this.exclude.getSpans(indexReader);
                this.moreExclude = this.excludeSpans.next();
            }

            @Override
            public boolean next() throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeSpans.next();
                }
                while (this.moreInclude && this.moreExclude) {
                    if (this.includeSpans.doc() > this.excludeSpans.doc()) {
                        this.moreExclude = this.excludeSpans.skipTo(this.includeSpans.doc());
                    }
                    while (this.moreExclude && this.includeSpans.doc() == this.excludeSpans.doc() && this.excludeSpans.end() <= this.includeSpans.start()) {
                        this.moreExclude = this.excludeSpans.next();
                    }
                    if (!this.moreExclude || this.includeSpans.doc() != this.excludeSpans.doc() || this.includeSpans.end() <= this.excludeSpans.start()) break;
                    this.moreInclude = this.includeSpans.next();
                }
                return this.moreInclude;
            }

            @Override
            public boolean skipTo(int n) throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeSpans.skipTo(n);
                }
                if (!this.moreInclude) {
                    return false;
                }
                if (this.moreExclude && this.includeSpans.doc() > this.excludeSpans.doc()) {
                    this.moreExclude = this.excludeSpans.skipTo(this.includeSpans.doc());
                }
                while (this.moreExclude && this.includeSpans.doc() == this.excludeSpans.doc() && this.excludeSpans.end() <= this.includeSpans.start()) {
                    this.moreExclude = this.excludeSpans.next();
                }
                if (!this.moreExclude || this.includeSpans.doc() != this.excludeSpans.doc() || this.includeSpans.end() <= this.excludeSpans.start()) {
                    return true;
                }
                return this.next();
            }

            @Override
            public int doc() {
                return this.includeSpans.doc();
            }

            @Override
            public int start() {
                return this.includeSpans.start();
            }

            @Override
            public int end() {
                return this.includeSpans.end();
            }

            @Override
            public Collection<byte[]> getPayload() throws IOException {
                ArrayList<byte[]> arrayList = null;
                if (this.includeSpans.isPayloadAvailable()) {
                    arrayList = new ArrayList<byte[]>(this.includeSpans.getPayload());
                }
                return arrayList;
            }

            @Override
            public boolean isPayloadAvailable() {
                return this.includeSpans.isPayloadAvailable();
            }

            public String toString() {
                return "spans(" + SpanNotQuery.this.toString() + ")";
            }
        };
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        SpanQuery spanQuery;
        SpanNotQuery spanNotQuery = null;
        SpanQuery spanQuery2 = (SpanQuery)this.include.rewrite(indexReader);
        if (spanQuery2 != this.include) {
            spanNotQuery = (SpanNotQuery)this.clone();
            spanNotQuery.include = spanQuery2;
        }
        if ((spanQuery = (SpanQuery)this.exclude.rewrite(indexReader)) != this.exclude) {
            if (spanNotQuery == null) {
                spanNotQuery = (SpanNotQuery)this.clone();
            }
            spanNotQuery.exclude = spanQuery;
        }
        if (spanNotQuery != null) {
            return spanNotQuery;
        }
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SpanNotQuery)) {
            return false;
        }
        SpanNotQuery spanNotQuery = (SpanNotQuery)object;
        return this.include.equals(spanNotQuery.include) && this.exclude.equals(spanNotQuery.exclude) && this.getBoost() == spanNotQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int n = this.include.hashCode();
        n = n << 1 | n >>> 31;
        n ^= this.exclude.hashCode();
        n = n << 1 | n >>> 31;
        return n ^= Float.floatToRawIntBits(this.getBoost());
    }
}

